/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Details for client authentication using TLS.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tls implements SdkPojo, Serializable, ToCopyableBuilder<Tls.Builder, Tls> {
    private static final SdkField<List<String>> CERTIFICATE_AUTHORITY_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CertificateAuthorityArnList")
            .getter(getter(Tls::certificateAuthorityArnList))
            .setter(setter(Builder::certificateAuthorityArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthorityArnList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CERTIFICATE_AUTHORITY_ARN_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> certificateAuthorityArnList;

    private Tls(BuilderImpl builder) {
        this.certificateAuthorityArnList = builder.certificateAuthorityArnList;
    }

    /**
     * Returns true if the CertificateAuthorityArnList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasCertificateAuthorityArnList() {
        return certificateAuthorityArnList != null && !(certificateAuthorityArnList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List of ACM Certificate Authority ARNs.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificateAuthorityArnList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         List of ACM Certificate Authority ARNs.
     *         </p>
     */
    public final List<String> certificateAuthorityArnList() {
        return certificateAuthorityArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateAuthorityArnList() ? certificateAuthorityArnList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tls)) {
            return false;
        }
        Tls other = (Tls) obj;
        return hasCertificateAuthorityArnList() == other.hasCertificateAuthorityArnList()
                && Objects.equals(certificateAuthorityArnList(), other.certificateAuthorityArnList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tls")
                .add("CertificateAuthorityArnList", hasCertificateAuthorityArnList() ? certificateAuthorityArnList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArnList":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArnList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tls, T> g) {
        return obj -> g.apply((Tls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tls> {
        /**
         *
         * <p>
         * List of ACM Certificate Authority ARNs.
         * </p>
         * 
         * @param certificateAuthorityArnList
         *        <p>
         *        List of ACM Certificate Authority ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArnList(Collection<String> certificateAuthorityArnList);

        /**
         *
         * <p>
         * List of ACM Certificate Authority ARNs.
         * </p>
         * 
         * @param certificateAuthorityArnList
         *        <p>
         *        List of ACM Certificate Authority ARNs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArnList(String... certificateAuthorityArnList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> certificateAuthorityArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Tls model) {
            certificateAuthorityArnList(model.certificateAuthorityArnList);
        }

        public final Collection<String> getCertificateAuthorityArnList() {
            if (certificateAuthorityArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateAuthorityArnList;
        }

        @Override
        public final Builder certificateAuthorityArnList(Collection<String> certificateAuthorityArnList) {
            this.certificateAuthorityArnList = ___listOf__stringCopier.copy(certificateAuthorityArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorityArnList(String... certificateAuthorityArnList) {
            certificateAuthorityArnList(Arrays.asList(certificateAuthorityArnList));
            return this;
        }

        public final void setCertificateAuthorityArnList(Collection<String> certificateAuthorityArnList) {
            this.certificateAuthorityArnList = ___listOf__stringCopier.copy(certificateAuthorityArnList);
        }

        @Override
        public Tls build() {
            return new Tls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
