/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request body for UpdateMonitoring.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMonitoringRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateMonitoringRequest.Builder, UpdateMonitoringRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateMonitoringRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateMonitoringRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(UpdateMonitoringRequest::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoringInfo> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(UpdateMonitoringRequest::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoringInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(UpdateMonitoringRequest::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CURRENT_VERSION_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD));

    private final String clusterArn;

    private final String currentVersion;

    private final String enhancedMonitoring;

    private final OpenMonitoringInfo openMonitoring;

    private final LoggingInfo loggingInfo;

    private UpdateMonitoringRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster
     * to find its version. When this update operation is successful, it generates a new cluster version.
     * </p>
     * 
     * @return <p>
     *         The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
     *         cluster to find its version. When this update operation is successful, it generates a new cluster
     *         version.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * The settings for open monitoring.
     * </p>
     * 
     * @return <p>
     *         The settings for open monitoring.
     *         </p>
     */
    public final OpenMonitoringInfo openMonitoring() {
        return openMonitoring;
    }

    /**
     * Returns the value of the LoggingInfo property for this object.
     * 
     * @return The value of the LoggingInfo property for this object.
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringRequest)) {
            return false;
        }
        UpdateMonitoringRequest other = (UpdateMonitoringRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring()) && Objects.equals(loggingInfo(), other.loggingInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMonitoringRequest").add("ClusterArn", clusterArn())
                .add("CurrentVersion", currentVersion()).add("EnhancedMonitoring", enhancedMonitoringAsString())
                .add("OpenMonitoring", openMonitoring()).add("LoggingInfo", loggingInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringRequest, T> g) {
        return obj -> g.apply((UpdateMonitoringRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMonitoringRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
         * cluster to find its version. When this update operation is successful, it generates a new cluster version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an
         *        MSK cluster to find its version. When this update operation is successful, it generates a new cluster
         *        version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        The settings for open monitoring.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoringInfo openMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link OpenMonitoringInfo.Builder} avoiding the need to
         * create one manually via {@link OpenMonitoringInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenMonitoringInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoringInfo)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoringInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoringInfo)
         */
        default Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoringInfo.builder().applyMutation(openMonitoring).build());
        }

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * @param loggingInfo
         *        The new value for the LoggingInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * This is a convenience that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to create
         * one manually via {@link LoggingInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private String currentVersion;

        private String enhancedMonitoring;

        private OpenMonitoringInfo openMonitoring;

        private LoggingInfo loggingInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            currentVersion(model.currentVersion);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            loggingInfo(model.loggingInfo);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitoringRequest build() {
            return new UpdateMonitoringRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
