/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.KafkaClusterSummary;
import software.amazon.awssdk.services.kafka.model.ReplicationInfoSummary;
import software.amazon.awssdk.services.kafka.model.ReplicatorState;
import software.amazon.awssdk.services.kafka.model.___listOfKafkaClusterSummaryCopier;
import software.amazon.awssdk.services.kafka.model.___listOfReplicationInfoSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicatorSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicatorSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ReplicatorSummary.getter(ReplicatorSummary::creationTime)).setter(ReplicatorSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(ReplicatorSummary.getter(ReplicatorSummary::currentVersion)).setter(ReplicatorSummary.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<Boolean> IS_REPLICATOR_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsReplicatorReference").getter(ReplicatorSummary.getter(ReplicatorSummary::isReplicatorReference)).setter(ReplicatorSummary.setter(Builder::isReplicatorReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isReplicatorReference").build()}).build();
    private static final SdkField<List<KafkaClusterSummary>> KAFKA_CLUSTERS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KafkaClustersSummary").getter(ReplicatorSummary.getter(ReplicatorSummary::kafkaClustersSummary)).setter(ReplicatorSummary.setter(Builder::kafkaClustersSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClustersSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KafkaClusterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReplicationInfoSummary>> REPLICATION_INFO_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInfoSummaryList").getter(ReplicatorSummary.getter(ReplicatorSummary::replicationInfoSummaryList)).setter(ReplicatorSummary.setter(Builder::replicationInfoSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationInfoSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorArn").getter(ReplicatorSummary.getter(ReplicatorSummary::replicatorArn)).setter(ReplicatorSummary.setter(Builder::replicatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()}).build();
    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorName").getter(ReplicatorSummary.getter(ReplicatorSummary::replicatorName)).setter(ReplicatorSummary.setter(Builder::replicatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()}).build();
    private static final SdkField<String> REPLICATOR_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorResourceArn").getter(ReplicatorSummary.getter(ReplicatorSummary::replicatorResourceArn)).setter(ReplicatorSummary.setter(Builder::replicatorResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorResourceArn").build()}).build();
    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorState").getter(ReplicatorSummary.getter(ReplicatorSummary::replicatorStateAsString)).setter(ReplicatorSummary.setter(Builder::replicatorState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, IS_REPLICATOR_REFERENCE_FIELD, KAFKA_CLUSTERS_SUMMARY_FIELD, REPLICATION_INFO_SUMMARY_LIST_FIELD, REPLICATOR_ARN_FIELD, REPLICATOR_NAME_FIELD, REPLICATOR_RESOURCE_ARN_FIELD, REPLICATOR_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("currentVersion", CURRENT_VERSION_FIELD);
            this.put("isReplicatorReference", IS_REPLICATOR_REFERENCE_FIELD);
            this.put("kafkaClustersSummary", KAFKA_CLUSTERS_SUMMARY_FIELD);
            this.put("replicationInfoSummaryList", REPLICATION_INFO_SUMMARY_LIST_FIELD);
            this.put("replicatorArn", REPLICATOR_ARN_FIELD);
            this.put("replicatorName", REPLICATOR_NAME_FIELD);
            this.put("replicatorResourceArn", REPLICATOR_RESOURCE_ARN_FIELD);
            this.put("replicatorState", REPLICATOR_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String currentVersion;
    private final Boolean isReplicatorReference;
    private final List<KafkaClusterSummary> kafkaClustersSummary;
    private final List<ReplicationInfoSummary> replicationInfoSummaryList;
    private final String replicatorArn;
    private final String replicatorName;
    private final String replicatorResourceArn;
    private final String replicatorState;

    private ReplicatorSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.isReplicatorReference = builder.isReplicatorReference;
        this.kafkaClustersSummary = builder.kafkaClustersSummary;
        this.replicationInfoSummaryList = builder.replicationInfoSummaryList;
        this.replicatorArn = builder.replicatorArn;
        this.replicatorName = builder.replicatorName;
        this.replicatorResourceArn = builder.replicatorResourceArn;
        this.replicatorState = builder.replicatorState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final Boolean isReplicatorReference() {
        return this.isReplicatorReference;
    }

    public final boolean hasKafkaClustersSummary() {
        return this.kafkaClustersSummary != null && !(this.kafkaClustersSummary instanceof SdkAutoConstructList);
    }

    public final List<KafkaClusterSummary> kafkaClustersSummary() {
        return this.kafkaClustersSummary;
    }

    public final boolean hasReplicationInfoSummaryList() {
        return this.replicationInfoSummaryList != null && !(this.replicationInfoSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ReplicationInfoSummary> replicationInfoSummaryList() {
        return this.replicationInfoSummaryList;
    }

    public final String replicatorArn() {
        return this.replicatorArn;
    }

    public final String replicatorName() {
        return this.replicatorName;
    }

    public final String replicatorResourceArn() {
        return this.replicatorResourceArn;
    }

    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(this.replicatorState);
    }

    public final String replicatorStateAsString() {
        return this.replicatorState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isReplicatorReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKafkaClustersSummary() ? this.kafkaClustersSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInfoSummaryList() ? this.replicationInfoSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicatorSummary)) {
            return false;
        }
        ReplicatorSummary other = (ReplicatorSummary)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.isReplicatorReference(), other.isReplicatorReference()) && this.hasKafkaClustersSummary() == other.hasKafkaClustersSummary() && Objects.equals(this.kafkaClustersSummary(), other.kafkaClustersSummary()) && this.hasReplicationInfoSummaryList() == other.hasReplicationInfoSummaryList() && Objects.equals(this.replicationInfoSummaryList(), other.replicationInfoSummaryList()) && Objects.equals(this.replicatorArn(), other.replicatorArn()) && Objects.equals(this.replicatorName(), other.replicatorName()) && Objects.equals(this.replicatorResourceArn(), other.replicatorResourceArn()) && Objects.equals(this.replicatorStateAsString(), other.replicatorStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicatorSummary").add("CreationTime", (Object)this.creationTime()).add("CurrentVersion", (Object)this.currentVersion()).add("IsReplicatorReference", (Object)this.isReplicatorReference()).add("KafkaClustersSummary", this.hasKafkaClustersSummary() ? this.kafkaClustersSummary() : null).add("ReplicationInfoSummaryList", this.hasReplicationInfoSummaryList() ? this.replicationInfoSummaryList() : null).add("ReplicatorArn", (Object)this.replicatorArn()).add("ReplicatorName", (Object)this.replicatorName()).add("ReplicatorResourceArn", (Object)this.replicatorResourceArn()).add("ReplicatorState", (Object)this.replicatorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "IsReplicatorReference": {
                return Optional.ofNullable(clazz.cast(this.isReplicatorReference()));
            }
            case "KafkaClustersSummary": {
                return Optional.ofNullable(clazz.cast(this.kafkaClustersSummary()));
            }
            case "ReplicationInfoSummaryList": {
                return Optional.ofNullable(clazz.cast(this.replicationInfoSummaryList()));
            }
            case "ReplicatorArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorArn()));
            }
            case "ReplicatorName": {
                return Optional.ofNullable(clazz.cast(this.replicatorName()));
            }
            case "ReplicatorResourceArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorResourceArn()));
            }
            case "ReplicatorState": {
                return Optional.ofNullable(clazz.cast(this.replicatorStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicatorSummary, T> g) {
        return obj -> g.apply((ReplicatorSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String currentVersion;
        private Boolean isReplicatorReference;
        private List<KafkaClusterSummary> kafkaClustersSummary = DefaultSdkAutoConstructList.getInstance();
        private List<ReplicationInfoSummary> replicationInfoSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String replicatorArn;
        private String replicatorName;
        private String replicatorResourceArn;
        private String replicatorState;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicatorSummary model) {
            this.creationTime(model.creationTime);
            this.currentVersion(model.currentVersion);
            this.isReplicatorReference(model.isReplicatorReference);
            this.kafkaClustersSummary(model.kafkaClustersSummary);
            this.replicationInfoSummaryList(model.replicationInfoSummaryList);
            this.replicatorArn(model.replicatorArn);
            this.replicatorName(model.replicatorName);
            this.replicatorResourceArn(model.replicatorResourceArn);
            this.replicatorState(model.replicatorState);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Boolean getIsReplicatorReference() {
            return this.isReplicatorReference;
        }

        public final void setIsReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
        }

        @Override
        public final Builder isReplicatorReference(Boolean isReplicatorReference) {
            this.isReplicatorReference = isReplicatorReference;
            return this;
        }

        public final List<KafkaClusterSummary.Builder> getKafkaClustersSummary() {
            List<KafkaClusterSummary.Builder> result = ___listOfKafkaClusterSummaryCopier.copyToBuilder(this.kafkaClustersSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClustersSummary(Collection<KafkaClusterSummary.BuilderImpl> kafkaClustersSummary) {
            this.kafkaClustersSummary = ___listOfKafkaClusterSummaryCopier.copyFromBuilder(kafkaClustersSummary);
        }

        @Override
        public final Builder kafkaClustersSummary(Collection<KafkaClusterSummary> kafkaClustersSummary) {
            this.kafkaClustersSummary = ___listOfKafkaClusterSummaryCopier.copy(kafkaClustersSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClustersSummary(KafkaClusterSummary ... kafkaClustersSummary) {
            this.kafkaClustersSummary(Arrays.asList(kafkaClustersSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClustersSummary(Consumer<KafkaClusterSummary.Builder> ... kafkaClustersSummary) {
            this.kafkaClustersSummary(Stream.of(kafkaClustersSummary).map(c -> (KafkaClusterSummary)((KafkaClusterSummary.Builder)KafkaClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfoSummary.Builder> getReplicationInfoSummaryList() {
            List<ReplicationInfoSummary.Builder> result = ___listOfReplicationInfoSummaryCopier.copyToBuilder(this.replicationInfoSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoSummaryList(Collection<ReplicationInfoSummary.BuilderImpl> replicationInfoSummaryList) {
            this.replicationInfoSummaryList = ___listOfReplicationInfoSummaryCopier.copyFromBuilder(replicationInfoSummaryList);
        }

        @Override
        public final Builder replicationInfoSummaryList(Collection<ReplicationInfoSummary> replicationInfoSummaryList) {
            this.replicationInfoSummaryList = ___listOfReplicationInfoSummaryCopier.copy(replicationInfoSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoSummaryList(ReplicationInfoSummary ... replicationInfoSummaryList) {
            this.replicationInfoSummaryList(Arrays.asList(replicationInfoSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoSummaryList(Consumer<ReplicationInfoSummary.Builder> ... replicationInfoSummaryList) {
            this.replicationInfoSummaryList(Stream.of(replicationInfoSummaryList).map(c -> (ReplicationInfoSummary)((ReplicationInfoSummary.Builder)ReplicationInfoSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorArn() {
            return this.replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorName() {
            return this.replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getReplicatorResourceArn() {
            return this.replicatorResourceArn;
        }

        public final void setReplicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
        }

        @Override
        public final Builder replicatorResourceArn(String replicatorResourceArn) {
            this.replicatorResourceArn = replicatorResourceArn;
            return this;
        }

        public final String getReplicatorState() {
            return this.replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        public ReplicatorSummary build() {
            return new ReplicatorSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicatorSummary> {
        public Builder creationTime(Instant var1);

        public Builder currentVersion(String var1);

        public Builder isReplicatorReference(Boolean var1);

        public Builder kafkaClustersSummary(Collection<KafkaClusterSummary> var1);

        public Builder kafkaClustersSummary(KafkaClusterSummary ... var1);

        public Builder kafkaClustersSummary(Consumer<KafkaClusterSummary.Builder> ... var1);

        public Builder replicationInfoSummaryList(Collection<ReplicationInfoSummary> var1);

        public Builder replicationInfoSummaryList(ReplicationInfoSummary ... var1);

        public Builder replicationInfoSummaryList(Consumer<ReplicationInfoSummary.Builder> ... var1);

        public Builder replicatorArn(String var1);

        public Builder replicatorName(String var1);

        public Builder replicatorResourceArn(String var1);

        public Builder replicatorState(String var1);

        public Builder replicatorState(ReplicatorState var1);
    }
}

