/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__integerCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicPartitionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicPartitionInfo> {
    private static final SdkField<Integer> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Partition").getter(TopicPartitionInfo.getter(TopicPartitionInfo::partition)).setter(TopicPartitionInfo.setter(Builder::partition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()}).build();
    private static final SdkField<Integer> LEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Leader").getter(TopicPartitionInfo.getter(TopicPartitionInfo::leader)).setter(TopicPartitionInfo.setter(Builder::leader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leader").build()}).build();
    private static final SdkField<List<Integer>> REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replicas").getter(TopicPartitionInfo.getter(TopicPartitionInfo::replicas)).setter(TopicPartitionInfo.setter(Builder::replicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> ISR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Isr").getter(TopicPartitionInfo.getter(TopicPartitionInfo::isr)).setter(TopicPartitionInfo.setter(Builder::isr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isr").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_FIELD, LEADER_FIELD, REPLICAS_FIELD, ISR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicPartitionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer partition;
    private final Integer leader;
    private final List<Integer> replicas;
    private final List<Integer> isr;

    private TopicPartitionInfo(BuilderImpl builder) {
        this.partition = builder.partition;
        this.leader = builder.leader;
        this.replicas = builder.replicas;
        this.isr = builder.isr;
    }

    public final Integer partition() {
        return this.partition;
    }

    public final Integer leader() {
        return this.leader;
    }

    public final boolean hasReplicas() {
        return this.replicas != null && !(this.replicas instanceof SdkAutoConstructList);
    }

    public final List<Integer> replicas() {
        return this.replicas;
    }

    public final boolean hasIsr() {
        return this.isr != null && !(this.isr instanceof SdkAutoConstructList);
    }

    public final List<Integer> isr() {
        return this.isr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partition());
        hashCode = 31 * hashCode + Objects.hashCode(this.leader());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicas() ? this.replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIsr() ? this.isr() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicPartitionInfo)) {
            return false;
        }
        TopicPartitionInfo other = (TopicPartitionInfo)obj;
        return Objects.equals(this.partition(), other.partition()) && Objects.equals(this.leader(), other.leader()) && this.hasReplicas() == other.hasReplicas() && Objects.equals(this.replicas(), other.replicas()) && this.hasIsr() == other.hasIsr() && Objects.equals(this.isr(), other.isr());
    }

    public final String toString() {
        return ToString.builder((String)"TopicPartitionInfo").add("Partition", (Object)this.partition()).add("Leader", (Object)this.leader()).add("Replicas", this.hasReplicas() ? this.replicas() : null).add("Isr", this.hasIsr() ? this.isr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partition": {
                return Optional.ofNullable(clazz.cast(this.partition()));
            }
            case "Leader": {
                return Optional.ofNullable(clazz.cast(this.leader()));
            }
            case "Replicas": {
                return Optional.ofNullable(clazz.cast(this.replicas()));
            }
            case "Isr": {
                return Optional.ofNullable(clazz.cast(this.isr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("partition", PARTITION_FIELD);
        map.put("leader", LEADER_FIELD);
        map.put("replicas", REPLICAS_FIELD);
        map.put("isr", ISR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicPartitionInfo, T> g) {
        return obj -> g.apply((TopicPartitionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer partition;
        private Integer leader;
        private List<Integer> replicas = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> isr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicPartitionInfo model) {
            this.partition(model.partition);
            this.leader(model.leader);
            this.replicas(model.replicas);
            this.isr(model.isr);
        }

        public final Integer getPartition() {
            return this.partition;
        }

        public final void setPartition(Integer partition) {
            this.partition = partition;
        }

        @Override
        public final Builder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public final Integer getLeader() {
            return this.leader;
        }

        public final void setLeader(Integer leader) {
            this.leader = leader;
        }

        @Override
        public final Builder leader(Integer leader) {
            this.leader = leader;
            return this;
        }

        public final Collection<Integer> getReplicas() {
            if (this.replicas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicas;
        }

        public final void setReplicas(Collection<Integer> replicas) {
            this.replicas = ___listOf__integerCopier.copy(replicas);
        }

        @Override
        public final Builder replicas(Collection<Integer> replicas) {
            this.replicas = ___listOf__integerCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Integer ... replicas) {
            this.replicas(Arrays.asList(replicas));
            return this;
        }

        public final Collection<Integer> getIsr() {
            if (this.isr instanceof SdkAutoConstructList) {
                return null;
            }
            return this.isr;
        }

        public final void setIsr(Collection<Integer> isr) {
            this.isr = ___listOf__integerCopier.copy(isr);
        }

        @Override
        public final Builder isr(Collection<Integer> isr) {
            this.isr = ___listOf__integerCopier.copy(isr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isr(Integer ... isr) {
            this.isr(Arrays.asList(isr));
            return this;
        }

        public TopicPartitionInfo build() {
            return new TopicPartitionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicPartitionInfo> {
        public Builder partition(Integer var1);

        public Builder leader(Integer var1);

        public Builder replicas(Collection<Integer> var1);

        public Builder replicas(Integer ... var1);

        public Builder isr(Collection<Integer> var1);

        public Builder isr(Integer ... var1);
    }
}

