/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ListTopicsRequest;
import software.amazon.awssdk.services.kafka.model.ListTopicsResponse;
import software.amazon.awssdk.services.kafka.model.TopicInfo;

public class ListTopicsIterable
implements SdkIterable<ListTopicsResponse> {
    private final KafkaClient client;
    private final ListTopicsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicsIterable(KafkaClient client, ListTopicsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public Iterator<ListTopicsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicInfo> topics() {
        Function<ListTopicsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topics() != null) {
                return response.topics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTopicsResponseFetcher
    implements SyncPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTopicsResponse nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsIterable.this.client.listTopics(ListTopicsIterable.this.firstRequest);
            }
            return ListTopicsIterable.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

