/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ClusterOperationInfo;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse;

public class ListClusterOperationsPublisher
implements SdkPublisher<ListClusterOperationsResponse> {
    private final KafkaAsyncClient client;
    private final ListClusterOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClusterOperationsPublisher(KafkaAsyncClient client, ListClusterOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClusterOperationsPublisher(KafkaAsyncClient client, ListClusterOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClusterOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClusterOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterOperationInfo> clusterOperationInfoList() {
        return this.flatMapIterable(response -> response.clusterOperationInfoList());
    }

    private class ListClusterOperationsResponseFetcher
    implements AsyncPageFetcher<ListClusterOperationsResponse> {
        private ListClusterOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClusterOperationsResponse> nextPage(ListClusterOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterOperationsPublisher.this.client.listClusterOperations(ListClusterOperationsPublisher.this.firstRequest);
            }
            return ListClusterOperationsPublisher.this.client.listClusterOperations((ListClusterOperationsRequest)((Object)ListClusterOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

