/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.GroupMembers;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPrincipalMappingRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, PutPrincipalMappingRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::indexId)).setter(PutPrincipalMappingRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::dataSourceId)).setter(PutPrincipalMappingRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::groupId)).setter(PutPrincipalMappingRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<GroupMembers> GROUP_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroupMembers").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::groupMembers)).setter(PutPrincipalMappingRequest.setter(Builder::groupMembers)).constructor(GroupMembers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMembers").build()}).build();
    private static final SdkField<Long> ORDERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("OrderingId").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::orderingId)).setter(PutPrincipalMappingRequest.setter(Builder::orderingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(PutPrincipalMappingRequest.getter(PutPrincipalMappingRequest::roleArn)).setter(PutPrincipalMappingRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD, GROUP_MEMBERS_FIELD, ORDERING_ID_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutPrincipalMappingRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String dataSourceId;
    private final String groupId;
    private final GroupMembers groupMembers;
    private final Long orderingId;
    private final String roleArn;

    private PutPrincipalMappingRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
        this.groupMembers = builder.groupMembers;
        this.orderingId = builder.orderingId;
        this.roleArn = builder.roleArn;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final GroupMembers groupMembers() {
        return this.groupMembers;
    }

    public final Long orderingId() {
        return this.orderingId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupMembers());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPrincipalMappingRequest)) {
            return false;
        }
        PutPrincipalMappingRequest other = (PutPrincipalMappingRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupMembers(), other.groupMembers()) && Objects.equals(this.orderingId(), other.orderingId()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutPrincipalMappingRequest").add("IndexId", (Object)this.indexId()).add("DataSourceId", (Object)this.dataSourceId()).add("GroupId", (Object)this.groupId()).add("GroupMembers", (Object)this.groupMembers()).add("OrderingId", (Object)this.orderingId()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupMembers": {
                return Optional.ofNullable(clazz.cast(this.groupMembers()));
            }
            case "OrderingId": {
                return Optional.ofNullable(clazz.cast(this.orderingId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("GroupMembers", GROUP_MEMBERS_FIELD);
        map.put("OrderingId", ORDERING_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutPrincipalMappingRequest, T> g) {
        return obj -> g.apply((PutPrincipalMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String dataSourceId;
        private String groupId;
        private GroupMembers groupMembers;
        private Long orderingId;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPrincipalMappingRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.dataSourceId(model.dataSourceId);
            this.groupId(model.groupId);
            this.groupMembers(model.groupMembers);
            this.orderingId(model.orderingId);
            this.roleArn(model.roleArn);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final GroupMembers.Builder getGroupMembers() {
            return this.groupMembers != null ? this.groupMembers.toBuilder() : null;
        }

        public final void setGroupMembers(GroupMembers.BuilderImpl groupMembers) {
            this.groupMembers = groupMembers != null ? groupMembers.build() : null;
        }

        @Override
        public final Builder groupMembers(GroupMembers groupMembers) {
            this.groupMembers = groupMembers;
            return this;
        }

        public final Long getOrderingId() {
            return this.orderingId;
        }

        public final void setOrderingId(Long orderingId) {
            this.orderingId = orderingId;
        }

        @Override
        public final Builder orderingId(Long orderingId) {
            this.orderingId = orderingId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPrincipalMappingRequest build() {
            return new PutPrincipalMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPrincipalMappingRequest> {
        public Builder indexId(String var1);

        public Builder dataSourceId(String var1);

        public Builder groupId(String var1);

        public Builder groupMembers(GroupMembers var1);

        default public Builder groupMembers(Consumer<GroupMembers.Builder> groupMembers) {
            return this.groupMembers((GroupMembers)((GroupMembers.Builder)GroupMembers.builder().applyMutation(groupMembers)).build());
        }

        public Builder orderingId(Long var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

