/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary;
import software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummaryListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperienceEntitiesResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListExperienceEntitiesResponse> {
    private static final SdkField<List<ExperienceEntitiesSummary>> SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryItems").getter(ListExperienceEntitiesResponse.getter(ListExperienceEntitiesResponse::summaryItems)).setter(ListExperienceEntitiesResponse.setter(Builder::summaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperienceEntitiesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExperienceEntitiesResponse.getter(ListExperienceEntitiesResponse::nextToken)).setter(ListExperienceEntitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExperienceEntitiesResponse.memberNameToFieldInitializer();
    private final List<ExperienceEntitiesSummary> summaryItems;
    private final String nextToken;

    private ListExperienceEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.summaryItems = builder.summaryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummaryItems() {
        return this.summaryItems != null && !(this.summaryItems instanceof SdkAutoConstructList);
    }

    public final List<ExperienceEntitiesSummary> summaryItems() {
        return this.summaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryItems() ? this.summaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperienceEntitiesResponse)) {
            return false;
        }
        ListExperienceEntitiesResponse other = (ListExperienceEntitiesResponse)((Object)obj);
        return this.hasSummaryItems() == other.hasSummaryItems() && Objects.equals(this.summaryItems(), other.summaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperienceEntitiesResponse").add("SummaryItems", this.hasSummaryItems() ? this.summaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryItems": {
                return Optional.ofNullable(clazz.cast(this.summaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SummaryItems", SUMMARY_ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExperienceEntitiesResponse, T> g) {
        return obj -> g.apply((ListExperienceEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private List<ExperienceEntitiesSummary> summaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperienceEntitiesResponse model) {
            super(model);
            this.summaryItems(model.summaryItems);
            this.nextToken(model.nextToken);
        }

        public final List<ExperienceEntitiesSummary.Builder> getSummaryItems() {
            List<ExperienceEntitiesSummary.Builder> result = ExperienceEntitiesSummaryListCopier.copyToBuilder(this.summaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryItems(Collection<ExperienceEntitiesSummary.BuilderImpl> summaryItems) {
            this.summaryItems = ExperienceEntitiesSummaryListCopier.copyFromBuilder(summaryItems);
        }

        @Override
        public final Builder summaryItems(Collection<ExperienceEntitiesSummary> summaryItems) {
            this.summaryItems = ExperienceEntitiesSummaryListCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(ExperienceEntitiesSummary ... summaryItems) {
            this.summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<ExperienceEntitiesSummary.Builder> ... summaryItems) {
            this.summaryItems(Stream.of(summaryItems).map(c -> (ExperienceEntitiesSummary)((ExperienceEntitiesSummary.Builder)ExperienceEntitiesSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExperienceEntitiesResponse build() {
            return new ListExperienceEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperienceEntitiesResponse> {
        public Builder summaryItems(Collection<ExperienceEntitiesSummary> var1);

        public Builder summaryItems(ExperienceEntitiesSummary ... var1);

        public Builder summaryItems(Consumer<ExperienceEntitiesSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

