/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.SourceDocument;
import software.amazon.awssdk.services.kendra.model.SourceDocumentsCopier;
import software.amazon.awssdk.services.kendra.model.SuggestionValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Suggestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Suggestion> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Suggestion.getter(Suggestion::id)).setter(Suggestion.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<SuggestionValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(Suggestion.getter(Suggestion::value)).setter(Suggestion.setter(Builder::value)).constructor(SuggestionValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<List<SourceDocument>> SOURCE_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDocuments").getter(Suggestion.getter(Suggestion::sourceDocuments)).setter(Suggestion.setter(Builder::sourceDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALUE_FIELD, SOURCE_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Suggestion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final SuggestionValue value;
    private final List<SourceDocument> sourceDocuments;

    private Suggestion(BuilderImpl builder) {
        this.id = builder.id;
        this.value = builder.value;
        this.sourceDocuments = builder.sourceDocuments;
    }

    public final String id() {
        return this.id;
    }

    public final SuggestionValue value() {
        return this.value;
    }

    public final boolean hasSourceDocuments() {
        return this.sourceDocuments != null && !(this.sourceDocuments instanceof SdkAutoConstructList);
    }

    public final List<SourceDocument> sourceDocuments() {
        return this.sourceDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDocuments() ? this.sourceDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Suggestion)) {
            return false;
        }
        Suggestion other = (Suggestion)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.value(), other.value()) && this.hasSourceDocuments() == other.hasSourceDocuments() && Objects.equals(this.sourceDocuments(), other.sourceDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"Suggestion").add("Id", (Object)this.id()).add("Value", (Object)this.value()).add("SourceDocuments", this.hasSourceDocuments() ? this.sourceDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "SourceDocuments": {
                return Optional.ofNullable(clazz.cast(this.sourceDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("SourceDocuments", SOURCE_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Suggestion, T> g) {
        return obj -> g.apply((Suggestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private SuggestionValue value;
        private List<SourceDocument> sourceDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Suggestion model) {
            this.id(model.id);
            this.value(model.value);
            this.sourceDocuments(model.sourceDocuments);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SuggestionValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(SuggestionValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(SuggestionValue value) {
            this.value = value;
            return this;
        }

        public final List<SourceDocument.Builder> getSourceDocuments() {
            List<SourceDocument.Builder> result = SourceDocumentsCopier.copyToBuilder(this.sourceDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDocuments(Collection<SourceDocument.BuilderImpl> sourceDocuments) {
            this.sourceDocuments = SourceDocumentsCopier.copyFromBuilder(sourceDocuments);
        }

        @Override
        public final Builder sourceDocuments(Collection<SourceDocument> sourceDocuments) {
            this.sourceDocuments = SourceDocumentsCopier.copy(sourceDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDocuments(SourceDocument ... sourceDocuments) {
            this.sourceDocuments(Arrays.asList(sourceDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDocuments(Consumer<SourceDocument.Builder> ... sourceDocuments) {
            this.sourceDocuments(Stream.of(sourceDocuments).map(c -> (SourceDocument)((SourceDocument.Builder)SourceDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Suggestion build() {
            return new Suggestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Suggestion> {
        public Builder id(String var1);

        public Builder value(SuggestionValue var1);

        default public Builder value(Consumer<SuggestionValue.Builder> value) {
            return this.value((SuggestionValue)((SuggestionValue.Builder)SuggestionValue.builder().applyMutation(value)).build());
        }

        public Builder sourceDocuments(Collection<SourceDocument> var1);

        public Builder sourceDocuments(SourceDocument ... var1);

        public Builder sourceDocuments(Consumer<SourceDocument.Builder> ... var1);
    }
}

