/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FeaturedDocument;
import software.amazon.awssdk.services.kendra.model.FeaturedDocumentListCopier;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetStatus;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.QueryTextListCopier;
import software.amazon.awssdk.services.kendra.model.Tag;
import software.amazon.awssdk.services.kendra.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFeaturedResultsSetRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, CreateFeaturedResultsSetRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::indexId)).setter(CreateFeaturedResultsSetRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturedResultsSetName").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::featuredResultsSetName)).setter(CreateFeaturedResultsSetRequest.setter(Builder::featuredResultsSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::description)).setter(CreateFeaturedResultsSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::clientToken)).setter(CreateFeaturedResultsSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::statusAsString)).setter(CreateFeaturedResultsSetRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> QUERY_TEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryTexts").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::queryTexts)).setter(CreateFeaturedResultsSetRequest.setter(Builder::queryTexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FeaturedDocument>> FEATURED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedDocuments").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::featuredDocuments)).setter(CreateFeaturedResultsSetRequest.setter(Builder::featuredDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturedDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFeaturedResultsSetRequest.getter(CreateFeaturedResultsSetRequest::tags)).setter(CreateFeaturedResultsSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, FEATURED_RESULTS_SET_NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, STATUS_FIELD, QUERY_TEXTS_FIELD, FEATURED_DOCUMENTS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFeaturedResultsSetRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String featuredResultsSetName;
    private final String description;
    private final String clientToken;
    private final String status;
    private final List<String> queryTexts;
    private final List<FeaturedDocument> featuredDocuments;
    private final List<Tag> tags;

    private CreateFeaturedResultsSetRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.status = builder.status;
        this.queryTexts = builder.queryTexts;
        this.featuredDocuments = builder.featuredDocuments;
        this.tags = builder.tags;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String featuredResultsSetName() {
        return this.featuredResultsSetName;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasQueryTexts() {
        return this.queryTexts != null && !(this.queryTexts instanceof SdkAutoConstructList);
    }

    public final List<String> queryTexts() {
        return this.queryTexts;
    }

    public final boolean hasFeaturedDocuments() {
        return this.featuredDocuments != null && !(this.featuredDocuments instanceof SdkAutoConstructList);
    }

    public final List<FeaturedDocument> featuredDocuments() {
        return this.featuredDocuments;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryTexts() ? this.queryTexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedDocuments() ? this.featuredDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFeaturedResultsSetRequest)) {
            return false;
        }
        CreateFeaturedResultsSetRequest other = (CreateFeaturedResultsSetRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.featuredResultsSetName(), other.featuredResultsSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasQueryTexts() == other.hasQueryTexts() && Objects.equals(this.queryTexts(), other.queryTexts()) && this.hasFeaturedDocuments() == other.hasFeaturedDocuments() && Objects.equals(this.featuredDocuments(), other.featuredDocuments()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFeaturedResultsSetRequest").add("IndexId", (Object)this.indexId()).add("FeaturedResultsSetName", (Object)this.featuredResultsSetName()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("Status", (Object)this.statusAsString()).add("QueryTexts", this.hasQueryTexts() ? this.queryTexts() : null).add("FeaturedDocuments", this.hasFeaturedDocuments() ? this.featuredDocuments() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "FeaturedResultsSetName": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "QueryTexts": {
                return Optional.ofNullable(clazz.cast(this.queryTexts()));
            }
            case "FeaturedDocuments": {
                return Optional.ofNullable(clazz.cast(this.featuredDocuments()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("FeaturedResultsSetName", FEATURED_RESULTS_SET_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("QueryTexts", QUERY_TEXTS_FIELD);
        map.put("FeaturedDocuments", FEATURED_DOCUMENTS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFeaturedResultsSetRequest, T> g) {
        return obj -> g.apply((CreateFeaturedResultsSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String featuredResultsSetName;
        private String description;
        private String clientToken;
        private String status;
        private List<String> queryTexts = DefaultSdkAutoConstructList.getInstance();
        private List<FeaturedDocument> featuredDocuments = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFeaturedResultsSetRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.featuredResultsSetName(model.featuredResultsSetName);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.status(model.status);
            this.queryTexts(model.queryTexts);
            this.featuredDocuments(model.featuredDocuments);
            this.tags(model.tags);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return this.featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getQueryTexts() {
            if (this.queryTexts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryTexts;
        }

        public final void setQueryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
        }

        @Override
        public final Builder queryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryTexts(String ... queryTexts) {
            this.queryTexts(Arrays.asList(queryTexts));
            return this;
        }

        public final List<FeaturedDocument.Builder> getFeaturedDocuments() {
            List<FeaturedDocument.Builder> result = FeaturedDocumentListCopier.copyToBuilder(this.featuredDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocuments(Collection<FeaturedDocument.BuilderImpl> featuredDocuments) {
            this.featuredDocuments = FeaturedDocumentListCopier.copyFromBuilder(featuredDocuments);
        }

        @Override
        public final Builder featuredDocuments(Collection<FeaturedDocument> featuredDocuments) {
            this.featuredDocuments = FeaturedDocumentListCopier.copy(featuredDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocuments(FeaturedDocument ... featuredDocuments) {
            this.featuredDocuments(Arrays.asList(featuredDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocuments(Consumer<FeaturedDocument.Builder> ... featuredDocuments) {
            this.featuredDocuments(Stream.of(featuredDocuments).map(c -> (FeaturedDocument)((FeaturedDocument.Builder)FeaturedDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFeaturedResultsSetRequest build() {
            return new CreateFeaturedResultsSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFeaturedResultsSetRequest> {
        public Builder indexId(String var1);

        public Builder featuredResultsSetName(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder status(String var1);

        public Builder status(FeaturedResultsSetStatus var1);

        public Builder queryTexts(Collection<String> var1);

        public Builder queryTexts(String ... var1);

        public Builder featuredDocuments(Collection<FeaturedDocument> var1);

        public Builder featuredDocuments(FeaturedDocument ... var1);

        public Builder featuredDocuments(Consumer<FeaturedDocument.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

