/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.CapacityUnitsConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration;
import software.amazon.awssdk.services.kendra.model.DocumentMetadataConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.IndexEdition;
import software.amazon.awssdk.services.kendra.model.IndexStatistics;
import software.amazon.awssdk.services.kendra.model.IndexStatus;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.kendra.model.UserContextPolicy;
import software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration;
import software.amazon.awssdk.services.kendra.model.UserTokenConfiguration;
import software.amazon.awssdk.services.kendra.model.UserTokenConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeIndexResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeIndexResponse.getter(DescribeIndexResponse::name)).setter(DescribeIndexResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeIndexResponse.getter(DescribeIndexResponse::id)).setter(DescribeIndexResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(DescribeIndexResponse.getter(DescribeIndexResponse::editionAsString)).setter(DescribeIndexResponse.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeIndexResponse.getter(DescribeIndexResponse::roleArn)).setter(DescribeIndexResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerSideEncryptionConfiguration").getter(DescribeIndexResponse.getter(DescribeIndexResponse::serverSideEncryptionConfiguration)).setter(DescribeIndexResponse.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeIndexResponse.getter(DescribeIndexResponse::statusAsString)).setter(DescribeIndexResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeIndexResponse.getter(DescribeIndexResponse::description)).setter(DescribeIndexResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeIndexResponse.getter(DescribeIndexResponse::createdAt)).setter(DescribeIndexResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeIndexResponse.getter(DescribeIndexResponse::updatedAt)).setter(DescribeIndexResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentMetadataConfigurations").getter(DescribeIndexResponse.getter(DescribeIndexResponse::documentMetadataConfigurations)).setter(DescribeIndexResponse.setter(Builder::documentMetadataConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadataConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentMetadataConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IndexStatistics> INDEX_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndexStatistics").getter(DescribeIndexResponse.getter(DescribeIndexResponse::indexStatistics)).setter(DescribeIndexResponse.setter(Builder::indexStatistics)).constructor(IndexStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatistics").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(DescribeIndexResponse.getter(DescribeIndexResponse::errorMessage)).setter(DescribeIndexResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<CapacityUnitsConfiguration> CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityUnits").getter(DescribeIndexResponse.getter(DescribeIndexResponse::capacityUnits)).setter(DescribeIndexResponse.setter(Builder::capacityUnits)).constructor(CapacityUnitsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()}).build();
    private static final SdkField<List<UserTokenConfiguration>> USER_TOKEN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserTokenConfigurations").getter(DescribeIndexResponse.getter(DescribeIndexResponse::userTokenConfigurations)).setter(DescribeIndexResponse.setter(Builder::userTokenConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTokenConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserTokenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_CONTEXT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserContextPolicy").getter(DescribeIndexResponse.getter(DescribeIndexResponse::userContextPolicyAsString)).setter(DescribeIndexResponse.setter(Builder::userContextPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextPolicy").build()}).build();
    private static final SdkField<UserGroupResolutionConfiguration> USER_GROUP_RESOLUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserGroupResolutionConfiguration").getter(DescribeIndexResponse.getter(DescribeIndexResponse::userGroupResolutionConfiguration)).setter(DescribeIndexResponse.setter(Builder::userGroupResolutionConfiguration)).constructor(UserGroupResolutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, EDITION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DOCUMENT_METADATA_CONFIGURATIONS_FIELD, INDEX_STATISTICS_FIELD, ERROR_MESSAGE_FIELD, CAPACITY_UNITS_FIELD, USER_TOKEN_CONFIGURATIONS_FIELD, USER_CONTEXT_POLICY_FIELD, USER_GROUP_RESOLUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIndexResponse.memberNameToFieldInitializer();
    private final String name;
    private final String id;
    private final String edition;
    private final String roleArn;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final String status;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<DocumentMetadataConfiguration> documentMetadataConfigurations;
    private final IndexStatistics indexStatistics;
    private final String errorMessage;
    private final CapacityUnitsConfiguration capacityUnits;
    private final List<UserTokenConfiguration> userTokenConfigurations;
    private final String userContextPolicy;
    private final UserGroupResolutionConfiguration userGroupResolutionConfiguration;

    private DescribeIndexResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.edition = builder.edition;
        this.roleArn = builder.roleArn;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.documentMetadataConfigurations = builder.documentMetadataConfigurations;
        this.indexStatistics = builder.indexStatistics;
        this.errorMessage = builder.errorMessage;
        this.capacityUnits = builder.capacityUnits;
        this.userTokenConfigurations = builder.userTokenConfigurations;
        this.userContextPolicy = builder.userContextPolicy;
        this.userGroupResolutionConfiguration = builder.userGroupResolutionConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final IndexEdition edition() {
        return IndexEdition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final IndexStatus status() {
        return IndexStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasDocumentMetadataConfigurations() {
        return this.documentMetadataConfigurations != null && !(this.documentMetadataConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DocumentMetadataConfiguration> documentMetadataConfigurations() {
        return this.documentMetadataConfigurations;
    }

    public final IndexStatistics indexStatistics() {
        return this.indexStatistics;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final CapacityUnitsConfiguration capacityUnits() {
        return this.capacityUnits;
    }

    public final boolean hasUserTokenConfigurations() {
        return this.userTokenConfigurations != null && !(this.userTokenConfigurations instanceof SdkAutoConstructList);
    }

    public final List<UserTokenConfiguration> userTokenConfigurations() {
        return this.userTokenConfigurations;
    }

    public final UserContextPolicy userContextPolicy() {
        return UserContextPolicy.fromValue(this.userContextPolicy);
    }

    public final String userContextPolicyAsString() {
        return this.userContextPolicy;
    }

    public final UserGroupResolutionConfiguration userGroupResolutionConfiguration() {
        return this.userGroupResolutionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentMetadataConfigurations() ? this.documentMetadataConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserTokenConfigurations() ? this.userTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupResolutionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasDocumentMetadataConfigurations() == other.hasDocumentMetadataConfigurations() && Objects.equals(this.documentMetadataConfigurations(), other.documentMetadataConfigurations()) && Objects.equals(this.indexStatistics(), other.indexStatistics()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.capacityUnits(), other.capacityUnits()) && this.hasUserTokenConfigurations() == other.hasUserTokenConfigurations() && Objects.equals(this.userTokenConfigurations(), other.userTokenConfigurations()) && Objects.equals(this.userContextPolicyAsString(), other.userContextPolicyAsString()) && Objects.equals(this.userGroupResolutionConfiguration(), other.userGroupResolutionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIndexResponse").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Edition", (Object)this.editionAsString()).add("RoleArn", (Object)this.roleArn()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DocumentMetadataConfigurations", this.hasDocumentMetadataConfigurations() ? this.documentMetadataConfigurations() : null).add("IndexStatistics", (Object)this.indexStatistics()).add("ErrorMessage", (Object)this.errorMessage()).add("CapacityUnits", (Object)this.capacityUnits()).add("UserTokenConfigurations", this.hasUserTokenConfigurations() ? this.userTokenConfigurations() : null).add("UserContextPolicy", (Object)this.userContextPolicyAsString()).add("UserGroupResolutionConfiguration", (Object)this.userGroupResolutionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ServerSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "DocumentMetadataConfigurations": {
                return Optional.ofNullable(clazz.cast(this.documentMetadataConfigurations()));
            }
            case "IndexStatistics": {
                return Optional.ofNullable(clazz.cast(this.indexStatistics()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "CapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.capacityUnits()));
            }
            case "UserTokenConfigurations": {
                return Optional.ofNullable(clazz.cast(this.userTokenConfigurations()));
            }
            case "UserContextPolicy": {
                return Optional.ofNullable(clazz.cast(this.userContextPolicyAsString()));
            }
            case "UserGroupResolutionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userGroupResolutionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Edition", EDITION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ServerSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("DocumentMetadataConfigurations", DOCUMENT_METADATA_CONFIGURATIONS_FIELD);
        map.put("IndexStatistics", INDEX_STATISTICS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("CapacityUnits", CAPACITY_UNITS_FIELD);
        map.put("UserTokenConfigurations", USER_TOKEN_CONFIGURATIONS_FIELD);
        map.put("UserContextPolicy", USER_CONTEXT_POLICY_FIELD);
        map.put("UserGroupResolutionConfiguration", USER_GROUP_RESOLUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexResponse, T> g) {
        return obj -> g.apply((DescribeIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String edition;
        private String roleArn;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private String status;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private List<DocumentMetadataConfiguration> documentMetadataConfigurations = DefaultSdkAutoConstructList.getInstance();
        private IndexStatistics indexStatistics;
        private String errorMessage;
        private CapacityUnitsConfiguration capacityUnits;
        private List<UserTokenConfiguration> userTokenConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String userContextPolicy;
        private UserGroupResolutionConfiguration userGroupResolutionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexResponse model) {
            super(model);
            this.name(model.name);
            this.id(model.id);
            this.edition(model.edition);
            this.roleArn(model.roleArn);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.status(model.status);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.documentMetadataConfigurations(model.documentMetadataConfigurations);
            this.indexStatistics(model.indexStatistics);
            this.errorMessage(model.errorMessage);
            this.capacityUnits(model.capacityUnits);
            this.userTokenConfigurations(model.userTokenConfigurations);
            this.userContextPolicy(model.userContextPolicy);
            this.userGroupResolutionConfiguration(model.userGroupResolutionConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(IndexEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurations() {
            List<DocumentMetadataConfiguration.Builder> result = DocumentMetadataConfigurationListCopier.copyToBuilder(this.documentMetadataConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentMetadataConfigurations(Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier.copyFromBuilder(documentMetadataConfigurations);
        }

        @Override
        public final Builder documentMetadataConfigurations(Collection<DocumentMetadataConfiguration> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier.copy(documentMetadataConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(DocumentMetadataConfiguration ... documentMetadataConfigurations) {
            this.documentMetadataConfigurations(Arrays.asList(documentMetadataConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(Consumer<DocumentMetadataConfiguration.Builder> ... documentMetadataConfigurations) {
            this.documentMetadataConfigurations(Stream.of(documentMetadataConfigurations).map(c -> (DocumentMetadataConfiguration)((DocumentMetadataConfiguration.Builder)DocumentMetadataConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IndexStatistics.Builder getIndexStatistics() {
            return this.indexStatistics != null ? this.indexStatistics.toBuilder() : null;
        }

        public final void setIndexStatistics(IndexStatistics.BuilderImpl indexStatistics) {
            this.indexStatistics = indexStatistics != null ? indexStatistics.build() : null;
        }

        @Override
        public final Builder indexStatistics(IndexStatistics indexStatistics) {
            this.indexStatistics = indexStatistics;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final CapacityUnitsConfiguration.Builder getCapacityUnits() {
            return this.capacityUnits != null ? this.capacityUnits.toBuilder() : null;
        }

        public final void setCapacityUnits(CapacityUnitsConfiguration.BuilderImpl capacityUnits) {
            this.capacityUnits = capacityUnits != null ? capacityUnits.build() : null;
        }

        @Override
        public final Builder capacityUnits(CapacityUnitsConfiguration capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final List<UserTokenConfiguration.Builder> getUserTokenConfigurations() {
            List<UserTokenConfiguration.Builder> result = UserTokenConfigurationListCopier.copyToBuilder(this.userTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserTokenConfigurations(Collection<UserTokenConfiguration.BuilderImpl> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copyFromBuilder(userTokenConfigurations);
        }

        @Override
        public final Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copy(userTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(UserTokenConfiguration ... userTokenConfigurations) {
            this.userTokenConfigurations(Arrays.asList(userTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder> ... userTokenConfigurations) {
            this.userTokenConfigurations(Stream.of(userTokenConfigurations).map(c -> (UserTokenConfiguration)((UserTokenConfiguration.Builder)UserTokenConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserContextPolicy() {
            return this.userContextPolicy;
        }

        public final void setUserContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
        }

        @Override
        public final Builder userContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        @Override
        public final Builder userContextPolicy(UserContextPolicy userContextPolicy) {
            this.userContextPolicy(userContextPolicy == null ? null : userContextPolicy.toString());
            return this;
        }

        public final UserGroupResolutionConfiguration.Builder getUserGroupResolutionConfiguration() {
            return this.userGroupResolutionConfiguration != null ? this.userGroupResolutionConfiguration.toBuilder() : null;
        }

        public final void setUserGroupResolutionConfiguration(UserGroupResolutionConfiguration.BuilderImpl userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration.build() : null;
        }

        @Override
        public final Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        @Override
        public DescribeIndexResponse build() {
            return new DescribeIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexResponse> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder edition(String var1);

        public Builder edition(IndexEdition var1);

        public Builder roleArn(String var1);

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(IndexStatus var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder documentMetadataConfigurations(Collection<DocumentMetadataConfiguration> var1);

        public Builder documentMetadataConfigurations(DocumentMetadataConfiguration ... var1);

        public Builder documentMetadataConfigurations(Consumer<DocumentMetadataConfiguration.Builder> ... var1);

        public Builder indexStatistics(IndexStatistics var1);

        default public Builder indexStatistics(Consumer<IndexStatistics.Builder> indexStatistics) {
            return this.indexStatistics((IndexStatistics)((IndexStatistics.Builder)IndexStatistics.builder().applyMutation(indexStatistics)).build());
        }

        public Builder errorMessage(String var1);

        public Builder capacityUnits(CapacityUnitsConfiguration var1);

        default public Builder capacityUnits(Consumer<CapacityUnitsConfiguration.Builder> capacityUnits) {
            return this.capacityUnits((CapacityUnitsConfiguration)((CapacityUnitsConfiguration.Builder)CapacityUnitsConfiguration.builder().applyMutation(capacityUnits)).build());
        }

        public Builder userTokenConfigurations(Collection<UserTokenConfiguration> var1);

        public Builder userTokenConfigurations(UserTokenConfiguration ... var1);

        public Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder> ... var1);

        public Builder userContextPolicy(String var1);

        public Builder userContextPolicy(UserContextPolicy var1);

        public Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration var1);

        default public Builder userGroupResolutionConfiguration(Consumer<UserGroupResolutionConfiguration.Builder> userGroupResolutionConfiguration) {
            return this.userGroupResolutionConfiguration((UserGroupResolutionConfiguration)((UserGroupResolutionConfiguration.Builder)UserGroupResolutionConfiguration.builder().applyMutation(userGroupResolutionConfiguration)).build());
        }
    }
}

