/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTypeRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, GetTypeRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetTypeRequest.getter(GetTypeRequest::keyspaceName)).setter(GetTypeRequest.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(GetTypeRequest.getter(GetTypeRequest::typeName)).setter(GetTypeRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TYPE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTypeRequest.memberNameToFieldInitializer();
    private final String keyspaceName;
    private final String typeName;

    private GetTypeRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.typeName = builder.typeName;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String typeName() {
        return this.typeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypeRequest)) {
            return false;
        }
        GetTypeRequest other = (GetTypeRequest)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.typeName(), other.typeName());
    }

    public final String toString() {
        return ToString.builder((String)"GetTypeRequest").add("KeyspaceName", (Object)this.keyspaceName()).add("TypeName", (Object)this.typeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypeRequest, T> g) {
        return obj -> g.apply((GetTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypeRequest model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.typeName(model.typeName);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTypeRequest build() {
            return new GetTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTypeRequest> {
        public Builder keyspaceName(String var1);

        public Builder typeName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

