/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.ClientSideTimestamps;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ReplicationSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeyspaceRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, UpdateKeyspaceRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(UpdateKeyspaceRequest.getter(UpdateKeyspaceRequest::keyspaceName)).setter(UpdateKeyspaceRequest.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<ReplicationSpecification> REPLICATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("replicationSpecification").getter(UpdateKeyspaceRequest.getter(UpdateKeyspaceRequest::replicationSpecification)).setter(UpdateKeyspaceRequest.setter(Builder::replicationSpecification)).constructor(ReplicationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationSpecification").build()}).build();
    private static final SdkField<ClientSideTimestamps> CLIENT_SIDE_TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clientSideTimestamps").getter(UpdateKeyspaceRequest.getter(UpdateKeyspaceRequest::clientSideTimestamps)).setter(UpdateKeyspaceRequest.setter(Builder::clientSideTimestamps)).constructor(ClientSideTimestamps::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSideTimestamps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, REPLICATION_SPECIFICATION_FIELD, CLIENT_SIDE_TIMESTAMPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKeyspaceRequest.memberNameToFieldInitializer();
    private final String keyspaceName;
    private final ReplicationSpecification replicationSpecification;
    private final ClientSideTimestamps clientSideTimestamps;

    private UpdateKeyspaceRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.replicationSpecification = builder.replicationSpecification;
        this.clientSideTimestamps = builder.clientSideTimestamps;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final ReplicationSpecification replicationSpecification() {
        return this.replicationSpecification;
    }

    public final ClientSideTimestamps clientSideTimestamps() {
        return this.clientSideTimestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSideTimestamps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyspaceRequest)) {
            return false;
        }
        UpdateKeyspaceRequest other = (UpdateKeyspaceRequest)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.replicationSpecification(), other.replicationSpecification()) && Objects.equals(this.clientSideTimestamps(), other.clientSideTimestamps());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeyspaceRequest").add("KeyspaceName", (Object)this.keyspaceName()).add("ReplicationSpecification", (Object)this.replicationSpecification()).add("ClientSideTimestamps", (Object)this.clientSideTimestamps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "replicationSpecification": {
                return Optional.ofNullable(clazz.cast(this.replicationSpecification()));
            }
            case "clientSideTimestamps": {
                return Optional.ofNullable(clazz.cast(this.clientSideTimestamps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("replicationSpecification", REPLICATION_SPECIFICATION_FIELD);
        map.put("clientSideTimestamps", CLIENT_SIDE_TIMESTAMPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyspaceRequest, T> g) {
        return obj -> g.apply((UpdateKeyspaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private ReplicationSpecification replicationSpecification;
        private ClientSideTimestamps clientSideTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyspaceRequest model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.replicationSpecification(model.replicationSpecification);
            this.clientSideTimestamps(model.clientSideTimestamps);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final ReplicationSpecification.Builder getReplicationSpecification() {
            return this.replicationSpecification != null ? this.replicationSpecification.toBuilder() : null;
        }

        public final void setReplicationSpecification(ReplicationSpecification.BuilderImpl replicationSpecification) {
            this.replicationSpecification = replicationSpecification != null ? replicationSpecification.build() : null;
        }

        @Override
        public final Builder replicationSpecification(ReplicationSpecification replicationSpecification) {
            this.replicationSpecification = replicationSpecification;
            return this;
        }

        public final ClientSideTimestamps.Builder getClientSideTimestamps() {
            return this.clientSideTimestamps != null ? this.clientSideTimestamps.toBuilder() : null;
        }

        public final void setClientSideTimestamps(ClientSideTimestamps.BuilderImpl clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps != null ? clientSideTimestamps.build() : null;
        }

        @Override
        public final Builder clientSideTimestamps(ClientSideTimestamps clientSideTimestamps) {
            this.clientSideTimestamps = clientSideTimestamps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyspaceRequest build() {
            return new UpdateKeyspaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeyspaceRequest> {
        public Builder keyspaceName(String var1);

        public Builder replicationSpecification(ReplicationSpecification var1);

        default public Builder replicationSpecification(Consumer<ReplicationSpecification.Builder> replicationSpecification) {
            return this.replicationSpecification((ReplicationSpecification)((ReplicationSpecification.Builder)ReplicationSpecification.builder().applyMutation(replicationSpecification)).build());
        }

        public Builder clientSideTimestamps(ClientSideTimestamps var1);

        default public Builder clientSideTimestamps(Consumer<ClientSideTimestamps.Builder> clientSideTimestamps) {
            return this.clientSideTimestamps((ClientSideTimestamps)((ClientSideTimestamps.Builder)ClientSideTimestamps.builder().applyMutation(clientSideTimestamps)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

