/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartingPosition implements SdkPojo, Serializable,
        ToCopyableBuilder<StartingPosition.Builder, StartingPosition> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(StartingPosition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SequenceNumber").getter(getter(StartingPosition::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(StartingPosition::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SEQUENCE_NUMBER_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String sequenceNumber;

    private final Instant timestamp;

    private StartingPosition(BuilderImpl builder) {
        this.type = builder.type;
        this.sequenceNumber = builder.sequenceNumber;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * You can set the starting position to one of the following values:
     * </p>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in
     * the <code>SequenceNumber</code> field.
     * </p>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number
     * specified in the <code>SequenceNumber</code> field.
     * </p>
     * <p>
     * <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
     * <code>Timestamp</code> field.
     * </p>
     * <p>
     * <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data
     * record in the shard.
     * </p>
     * <p>
     * <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the
     * most recent data in the shard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can set the starting position to one of the following values:</p>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number
     *         specified in the <code>SequenceNumber</code> field.
     *         </p>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence
     *         number specified in the <code>SequenceNumber</code> field.
     *         </p>
     *         <p>
     *         <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
     *         <code>Timestamp</code> field.
     *         </p>
     *         <p>
     *         <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest
     *         data record in the shard.
     *         </p>
     *         <p>
     *         <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always
     *         read the most recent data in the shard.
     * @see ShardIteratorType
     */
    public final ShardIteratorType type() {
        return ShardIteratorType.fromValue(type);
    }

    /**
     * <p>
     * You can set the starting position to one of the following values:
     * </p>
     * <p>
     * <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in
     * the <code>SequenceNumber</code> field.
     * </p>
     * <p>
     * <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number
     * specified in the <code>SequenceNumber</code> field.
     * </p>
     * <p>
     * <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
     * <code>Timestamp</code> field.
     * </p>
     * <p>
     * <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data
     * record in the shard.
     * </p>
     * <p>
     * <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the
     * most recent data in the shard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return You can set the starting position to one of the following values:</p>
     *         <p>
     *         <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number
     *         specified in the <code>SequenceNumber</code> field.
     *         </p>
     *         <p>
     *         <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence
     *         number specified in the <code>SequenceNumber</code> field.
     *         </p>
     *         <p>
     *         <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
     *         <code>Timestamp</code> field.
     *         </p>
     *         <p>
     *         <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest
     *         data record in the shard.
     *         </p>
     *         <p>
     *         <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always
     *         read the most recent data in the shard.
     * @see ShardIteratorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The sequence number of the data record in the shard from which to start streaming. To specify a sequence number,
     * set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.
     * </p>
     * 
     * @return The sequence number of the data record in the shard from which to start streaming. To specify a sequence
     *         number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or
     *         <code>AFTER_SEQUENCE_NUMBER</code>.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The time stamp of the data record from which to start reading. To specify a time stamp, set
     * <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with
     * precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>
     * . If a record with this exact time stamp does not exist, records will be streamed from the next (later) record.
     * If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data
     * record (<code>TRIM_HORIZON</code>).
     * </p>
     * 
     * @return The time stamp of the data record from which to start reading. To specify a time stamp, set
     *         <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with
     *         precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or
     *         <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be
     *         streamed from the next (later) record. If the time stamp is older than the current trim horizon, records
     *         will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartingPosition)) {
            return false;
        }
        StartingPosition other = (StartingPosition) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartingPosition").add("Type", typeAsString()).add("SequenceNumber", sequenceNumber())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartingPosition, T> g) {
        return obj -> g.apply((StartingPosition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartingPosition> {
        /**
         * <p>
         * You can set the starting position to one of the following values:
         * </p>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified
         * in the <code>SequenceNumber</code> field.
         * </p>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number
         * specified in the <code>SequenceNumber</code> field.
         * </p>
         * <p>
         * <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
         * <code>Timestamp</code> field.
         * </p>
         * <p>
         * <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest
         * data record in the shard.
         * </p>
         * <p>
         * <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read
         * the most recent data in the shard.
         * </p>
         * 
         * @param type
         *        You can set the starting position to one of the following values:</p>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number
         *        specified in the <code>SequenceNumber</code> field.
         *        </p>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence
         *        number specified in the <code>SequenceNumber</code> field.
         *        </p>
         *        <p>
         *        <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in
         *        the <code>Timestamp</code> field.
         *        </p>
         *        <p>
         *        <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the
         *        oldest data record in the shard.
         *        </p>
         *        <p>
         *        <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you
         *        always read the most recent data in the shard.
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder type(String type);

        /**
         * <p>
         * You can set the starting position to one of the following values:
         * </p>
         * <p>
         * <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified
         * in the <code>SequenceNumber</code> field.
         * </p>
         * <p>
         * <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number
         * specified in the <code>SequenceNumber</code> field.
         * </p>
         * <p>
         * <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the
         * <code>Timestamp</code> field.
         * </p>
         * <p>
         * <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest
         * data record in the shard.
         * </p>
         * <p>
         * <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read
         * the most recent data in the shard.
         * </p>
         * 
         * @param type
         *        You can set the starting position to one of the following values:</p>
         *        <p>
         *        <code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number
         *        specified in the <code>SequenceNumber</code> field.
         *        </p>
         *        <p>
         *        <code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence
         *        number specified in the <code>SequenceNumber</code> field.
         *        </p>
         *        <p>
         *        <code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in
         *        the <code>Timestamp</code> field.
         *        </p>
         *        <p>
         *        <code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the
         *        oldest data record in the shard.
         *        </p>
         *        <p>
         *        <code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you
         *        always read the most recent data in the shard.
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder type(ShardIteratorType type);

        /**
         * <p>
         * The sequence number of the data record in the shard from which to start streaming. To specify a sequence
         * number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or
         * <code>AFTER_SEQUENCE_NUMBER</code>.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number of the data record in the shard from which to start streaming. To specify a
         *        sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or
         *        <code>AFTER_SEQUENCE_NUMBER</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The time stamp of the data record from which to start reading. To specify a time stamp, set
         * <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with
         * precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or
         * <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed
         * from the next (later) record. If the time stamp is older than the current trim horizon, records will be
         * streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).
         * </p>
         * 
         * @param timestamp
         *        The time stamp of the data record from which to start reading. To specify a time stamp, set
         *        <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date
         *        with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or
         *        <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be
         *        streamed from the next (later) record. If the time stamp is older than the current trim horizon,
         *        records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String sequenceNumber;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartingPosition model) {
            type(model.type);
            sequenceNumber(model.sequenceNumber);
            timestamp(model.timestamp);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardIteratorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public StartingPosition build() {
            return new StartingPosition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
