/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointParams;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;
import software.amazon.awssdk.services.kinesis.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.awssdk.services.kinesis.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesis.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateMaxRecordSizeRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateStreamModeRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateStreamWarmThroughputRequest;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class KinesisResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        KinesisEndpointProvider provider = (KinesisEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            KinesisEndpointParams endpointParams = KinesisResolveEndpointInterceptor.ruleParams(result, executionAttributes);
            Endpoint endpoint = provider.resolveEndpoint(endpointParams).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = KinesisResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            this.setMetricValues(endpoint, executionAttributes);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static KinesisEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        KinesisEndpointParams.Builder builder = KinesisEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        KinesisResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        KinesisResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        KinesisResolveEndpointInterceptor.setOperationContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        return builder.build();
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            case "AddTagsToStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (AddTagsToStreamRequest)request);
                break;
            }
            case "DecreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DecreaseStreamRetentionPeriodRequest)request);
                break;
            }
            case "DeleteResourcePolicy": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DeleteResourcePolicyRequest)request);
                break;
            }
            case "DeleteStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DeleteStreamRequest)request);
                break;
            }
            case "DeregisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DeregisterStreamConsumerRequest)request);
                break;
            }
            case "DescribeStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamRequest)request);
                break;
            }
            case "DescribeStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamConsumerRequest)request);
                break;
            }
            case "DescribeStreamSummary": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DescribeStreamSummaryRequest)request);
                break;
            }
            case "DisableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (DisableEnhancedMonitoringRequest)request);
                break;
            }
            case "EnableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (EnableEnhancedMonitoringRequest)request);
                break;
            }
            case "GetRecords": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (GetRecordsRequest)request);
                break;
            }
            case "GetResourcePolicy": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (GetResourcePolicyRequest)request);
                break;
            }
            case "GetShardIterator": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (GetShardIteratorRequest)request);
                break;
            }
            case "IncreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (IncreaseStreamRetentionPeriodRequest)request);
                break;
            }
            case "ListShards": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListShardsRequest)request);
                break;
            }
            case "ListStreamConsumers": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListStreamConsumersRequest)request);
                break;
            }
            case "ListTagsForResource": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListTagsForResourceRequest)request);
                break;
            }
            case "ListTagsForStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (ListTagsForStreamRequest)request);
                break;
            }
            case "MergeShards": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (MergeShardsRequest)request);
                break;
            }
            case "PutRecord": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (PutRecordRequest)request);
                break;
            }
            case "PutRecords": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (PutRecordsRequest)request);
                break;
            }
            case "PutResourcePolicy": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (PutResourcePolicyRequest)request);
                break;
            }
            case "RegisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (RegisterStreamConsumerRequest)request);
                break;
            }
            case "RemoveTagsFromStream": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (RemoveTagsFromStreamRequest)request);
                break;
            }
            case "SplitShard": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (SplitShardRequest)request);
                break;
            }
            case "StartStreamEncryption": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (StartStreamEncryptionRequest)request);
                break;
            }
            case "StopStreamEncryption": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (StopStreamEncryptionRequest)request);
                break;
            }
            case "SubscribeToShard": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (SubscribeToShardRequest)request);
                break;
            }
            case "TagResource": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (TagResourceRequest)request);
                break;
            }
            case "UntagResource": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UntagResourceRequest)request);
                break;
            }
            case "UpdateMaxRecordSize": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateMaxRecordSizeRequest)request);
                break;
            }
            case "UpdateShardCount": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateShardCountRequest)request);
                break;
            }
            case "UpdateStreamMode": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateStreamModeRequest)request);
                break;
            }
            case "UpdateStreamWarmThroughput": {
                KinesisResolveEndpointInterceptor.setContextParams(params, (UpdateStreamWarmThroughputRequest)request);
                break;
            }
        }
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, AddTagsToStreamRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DecreaseStreamRetentionPeriodRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DeleteResourcePolicyRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DeleteStreamRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DeregisterStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
        params.consumerArn(request.consumerARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
        params.consumerArn(request.consumerARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DescribeStreamSummaryRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, DisableEnhancedMonitoringRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, EnableEnhancedMonitoringRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, GetRecordsRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, GetResourcePolicyRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, GetShardIteratorRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, IncreaseStreamRetentionPeriodRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListShardsRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListStreamConsumersRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListTagsForResourceRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, ListTagsForStreamRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, MergeShardsRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, PutRecordRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, PutRecordsRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, PutResourcePolicyRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, RegisterStreamConsumerRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, RemoveTagsFromStreamRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, SplitShardRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, StartStreamEncryptionRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, StopStreamEncryptionRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, SubscribeToShardRequest request) {
        params.consumerArn(request.consumerARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, TagResourceRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UntagResourceRequest request) {
        params.resourceArn(request.resourceARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateMaxRecordSizeRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateShardCountRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateStreamModeRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setContextParams(KinesisEndpointParams.Builder params, UpdateStreamWarmThroughputRequest request) {
        params.streamArn(request.streamARN());
        params.streamId(request.streamId());
    }

    private static void setStaticContextParams(KinesisEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            case "AddTagsToStream": {
                KinesisResolveEndpointInterceptor.addTagsToStreamStaticContextParams(params);
                break;
            }
            case "DecreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.decreaseStreamRetentionPeriodStaticContextParams(params);
                break;
            }
            case "DeleteResourcePolicy": {
                KinesisResolveEndpointInterceptor.deleteResourcePolicyStaticContextParams(params);
                break;
            }
            case "DeleteStream": {
                KinesisResolveEndpointInterceptor.deleteStreamStaticContextParams(params);
                break;
            }
            case "DeregisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.deregisterStreamConsumerStaticContextParams(params);
                break;
            }
            case "DescribeStream": {
                KinesisResolveEndpointInterceptor.describeStreamStaticContextParams(params);
                break;
            }
            case "DescribeStreamConsumer": {
                KinesisResolveEndpointInterceptor.describeStreamConsumerStaticContextParams(params);
                break;
            }
            case "DescribeStreamSummary": {
                KinesisResolveEndpointInterceptor.describeStreamSummaryStaticContextParams(params);
                break;
            }
            case "DisableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.disableEnhancedMonitoringStaticContextParams(params);
                break;
            }
            case "EnableEnhancedMonitoring": {
                KinesisResolveEndpointInterceptor.enableEnhancedMonitoringStaticContextParams(params);
                break;
            }
            case "GetRecords": {
                KinesisResolveEndpointInterceptor.getRecordsStaticContextParams(params);
                break;
            }
            case "GetResourcePolicy": {
                KinesisResolveEndpointInterceptor.getResourcePolicyStaticContextParams(params);
                break;
            }
            case "GetShardIterator": {
                KinesisResolveEndpointInterceptor.getShardIteratorStaticContextParams(params);
                break;
            }
            case "IncreaseStreamRetentionPeriod": {
                KinesisResolveEndpointInterceptor.increaseStreamRetentionPeriodStaticContextParams(params);
                break;
            }
            case "ListShards": {
                KinesisResolveEndpointInterceptor.listShardsStaticContextParams(params);
                break;
            }
            case "ListStreamConsumers": {
                KinesisResolveEndpointInterceptor.listStreamConsumersStaticContextParams(params);
                break;
            }
            case "ListTagsForResource": {
                KinesisResolveEndpointInterceptor.listTagsForResourceStaticContextParams(params);
                break;
            }
            case "ListTagsForStream": {
                KinesisResolveEndpointInterceptor.listTagsForStreamStaticContextParams(params);
                break;
            }
            case "MergeShards": {
                KinesisResolveEndpointInterceptor.mergeShardsStaticContextParams(params);
                break;
            }
            case "PutRecord": {
                KinesisResolveEndpointInterceptor.putRecordStaticContextParams(params);
                break;
            }
            case "PutRecords": {
                KinesisResolveEndpointInterceptor.putRecordsStaticContextParams(params);
                break;
            }
            case "PutResourcePolicy": {
                KinesisResolveEndpointInterceptor.putResourcePolicyStaticContextParams(params);
                break;
            }
            case "RegisterStreamConsumer": {
                KinesisResolveEndpointInterceptor.registerStreamConsumerStaticContextParams(params);
                break;
            }
            case "RemoveTagsFromStream": {
                KinesisResolveEndpointInterceptor.removeTagsFromStreamStaticContextParams(params);
                break;
            }
            case "SplitShard": {
                KinesisResolveEndpointInterceptor.splitShardStaticContextParams(params);
                break;
            }
            case "StartStreamEncryption": {
                KinesisResolveEndpointInterceptor.startStreamEncryptionStaticContextParams(params);
                break;
            }
            case "StopStreamEncryption": {
                KinesisResolveEndpointInterceptor.stopStreamEncryptionStaticContextParams(params);
                break;
            }
            case "SubscribeToShard": {
                KinesisResolveEndpointInterceptor.subscribeToShardStaticContextParams(params);
                break;
            }
            case "TagResource": {
                KinesisResolveEndpointInterceptor.tagResourceStaticContextParams(params);
                break;
            }
            case "UntagResource": {
                KinesisResolveEndpointInterceptor.untagResourceStaticContextParams(params);
                break;
            }
            case "UpdateMaxRecordSize": {
                KinesisResolveEndpointInterceptor.updateMaxRecordSizeStaticContextParams(params);
                break;
            }
            case "UpdateShardCount": {
                KinesisResolveEndpointInterceptor.updateShardCountStaticContextParams(params);
                break;
            }
            case "UpdateStreamMode": {
                KinesisResolveEndpointInterceptor.updateStreamModeStaticContextParams(params);
                break;
            }
            case "UpdateStreamWarmThroughput": {
                KinesisResolveEndpointInterceptor.updateStreamWarmThroughputStaticContextParams(params);
                break;
            }
        }
    }

    private static void addTagsToStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void decreaseStreamRetentionPeriodStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void deleteResourcePolicyStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void deleteStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void deregisterStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void describeStreamSummaryStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void disableEnhancedMonitoringStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void enableEnhancedMonitoringStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void getRecordsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void getResourcePolicyStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void getShardIteratorStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void increaseStreamRetentionPeriodStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listShardsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listStreamConsumersStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listTagsForResourceStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void listTagsForStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void mergeShardsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void putRecordStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void putRecordsStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void putResourcePolicyStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void registerStreamConsumerStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void removeTagsFromStreamStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void splitShardStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void startStreamEncryptionStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void stopStreamEncryptionStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void subscribeToShardStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("data");
    }

    private static void tagResourceStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void untagResourceStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void updateMaxRecordSizeStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void updateShardCountStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void updateStreamModeStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private static void updateStreamWarmThroughputStaticContextParams(KinesisEndpointParams.Builder params) {
        params.operationType("control");
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (!CollectionUtils.isNullOrEmpty((Collection)v4aAuthScheme.signingRegionSet())) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setOperationContextParams(KinesisEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }

    private void setMetricValues(Endpoint endpoint, ExecutionAttributes executionAttributes) {
        if (endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES) != null) {
            executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS).ifPresent(metrics -> ((List)endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES)).forEach(v -> metrics.addMetric(v)));
        }
    }
}

