/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopStreamEncryptionRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, StopStreamEncryptionRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(StopStreamEncryptionRequest.getter(StopStreamEncryptionRequest::streamName)).setter(StopStreamEncryptionRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(StopStreamEncryptionRequest.getter(StopStreamEncryptionRequest::encryptionTypeAsString)).setter(StopStreamEncryptionRequest.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(StopStreamEncryptionRequest.getter(StopStreamEncryptionRequest::keyId)).setter(StopStreamEncryptionRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(StopStreamEncryptionRequest.getter(StopStreamEncryptionRequest::streamARN)).setter(StopStreamEncryptionRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(StopStreamEncryptionRequest.getter(StopStreamEncryptionRequest::streamId)).setter(StopStreamEncryptionRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, ENCRYPTION_TYPE_FIELD, KEY_ID_FIELD, STREAM_ARN_FIELD, STREAM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopStreamEncryptionRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String encryptionType;
    private final String keyId;
    private final String streamARN;
    private final String streamId;

    private StopStreamEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
        this.streamARN = builder.streamARN;
        this.streamId = builder.streamId;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String streamId() {
        return this.streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStreamEncryptionRequest)) {
            return false;
        }
        StopStreamEncryptionRequest other = (StopStreamEncryptionRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"StopStreamEncryptionRequest").add("StreamName", (Object)this.streamName()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("KeyId", (Object)this.keyId()).add("StreamARN", (Object)this.streamARN()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("KeyId", KEY_ID_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopStreamEncryptionRequest, T> g) {
        return obj -> g.apply((StopStreamEncryptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String encryptionType;
        private String keyId;
        private String streamARN;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStreamEncryptionRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
            this.streamARN(model.streamARN);
            this.streamId(model.streamId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopStreamEncryptionRequest build() {
            return new StopStreamEncryptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopStreamEncryptionRequest> {
        public Builder streamName(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);

        public Builder streamARN(String var1);

        public Builder streamId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

