/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.ScalingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateShardCountRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, UpdateShardCountRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::streamName)).setter(UpdateShardCountRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<Integer> TARGET_SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetShardCount").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::targetShardCount)).setter(UpdateShardCountRequest.setter(Builder::targetShardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetShardCount").build()}).build();
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingType").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::scalingTypeAsString)).setter(UpdateShardCountRequest.setter(Builder::scalingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::streamARN)).setter(UpdateShardCountRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(UpdateShardCountRequest.getter(UpdateShardCountRequest::streamId)).setter(UpdateShardCountRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, TARGET_SHARD_COUNT_FIELD, SCALING_TYPE_FIELD, STREAM_ARN_FIELD, STREAM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateShardCountRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final Integer targetShardCount;
    private final String scalingType;
    private final String streamARN;
    private final String streamId;

    private UpdateShardCountRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
        this.streamARN = builder.streamARN;
        this.streamId = builder.streamId;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final Integer targetShardCount() {
        return this.targetShardCount;
    }

    public final ScalingType scalingType() {
        return ScalingType.fromValue(this.scalingType);
    }

    public final String scalingTypeAsString() {
        return this.scalingType;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final String streamId() {
        return this.streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.targetShardCount(), other.targetShardCount()) && Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateShardCountRequest").add("StreamName", (Object)this.streamName()).add("TargetShardCount", (Object)this.targetShardCount()).add("ScalingType", (Object)this.scalingTypeAsString()).add("StreamARN", (Object)this.streamARN()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "TargetShardCount": {
                return Optional.ofNullable(clazz.cast(this.targetShardCount()));
            }
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("TargetShardCount", TARGET_SHARD_COUNT_FIELD);
        map.put("ScalingType", SCALING_TYPE_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateShardCountRequest, T> g) {
        return obj -> g.apply((UpdateShardCountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer targetShardCount;
        private String scalingType;
        private String streamARN;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.targetShardCount(model.targetShardCount);
            this.scalingType(model.scalingType);
            this.streamARN(model.streamARN);
            this.streamId(model.streamId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateShardCountRequest> {
        public Builder streamName(String var1);

        public Builder targetShardCount(Integer var1);

        public Builder scalingType(String var1);

        public Builder scalingType(ScalingType var1);

        public Builder streamARN(String var1);

        public Builder streamId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

