/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FormatConfigCopier;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FormatConfigKey;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageSelectorType;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImagesRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, GetImagesRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetImagesRequest.getter(GetImagesRequest::streamName)).setter(GetImagesRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetImagesRequest.getter(GetImagesRequest::streamARN)).setter(GetImagesRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> IMAGE_SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageSelectorType").getter(GetImagesRequest.getter(GetImagesRequest::imageSelectorTypeAsString)).setter(GetImagesRequest.setter(Builder::imageSelectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSelectorType").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(GetImagesRequest.getter(GetImagesRequest::startTimestamp)).setter(GetImagesRequest.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(GetImagesRequest.getter(GetImagesRequest::endTimestamp)).setter(GetImagesRequest.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<Integer> SAMPLING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SamplingInterval").getter(GetImagesRequest.getter(GetImagesRequest::samplingInterval)).setter(GetImagesRequest.setter(Builder::samplingInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingInterval").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(GetImagesRequest.getter(GetImagesRequest::formatAsString)).setter(GetImagesRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FormatConfig").getter(GetImagesRequest.getter(GetImagesRequest::formatConfigAsStrings)).setter(GetImagesRequest.setter(Builder::formatConfigWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfig").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> WIDTH_PIXELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WidthPixels").getter(GetImagesRequest.getter(GetImagesRequest::widthPixels)).setter(GetImagesRequest.setter(Builder::widthPixels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WidthPixels").build()}).build();
    private static final SdkField<Integer> HEIGHT_PIXELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HeightPixels").getter(GetImagesRequest.getter(GetImagesRequest::heightPixels)).setter(GetImagesRequest.setter(Builder::heightPixels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeightPixels").build()}).build();
    private static final SdkField<Long> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxResults").getter(GetImagesRequest.getter(GetImagesRequest::maxResults)).setter(GetImagesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetImagesRequest.getter(GetImagesRequest::nextToken)).setter(GetImagesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, IMAGE_SELECTOR_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, SAMPLING_INTERVAL_FIELD, FORMAT_FIELD, FORMAT_CONFIG_FIELD, WIDTH_PIXELS_FIELD, HEIGHT_PIXELS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetImagesRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String streamARN;
    private final String imageSelectorType;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final Integer samplingInterval;
    private final String format;
    private final Map<String, String> formatConfig;
    private final Integer widthPixels;
    private final Integer heightPixels;
    private final Long maxResults;
    private final String nextToken;

    private GetImagesRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.imageSelectorType = builder.imageSelectorType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.samplingInterval = builder.samplingInterval;
        this.format = builder.format;
        this.formatConfig = builder.formatConfig;
        this.widthPixels = builder.widthPixels;
        this.heightPixels = builder.heightPixels;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final ImageSelectorType imageSelectorType() {
        return ImageSelectorType.fromValue(this.imageSelectorType);
    }

    public final String imageSelectorTypeAsString() {
        return this.imageSelectorType;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final Integer samplingInterval() {
        return this.samplingInterval;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Map<FormatConfigKey, String> formatConfig() {
        return FormatConfigCopier.copyStringToEnum(this.formatConfig);
    }

    public final boolean hasFormatConfig() {
        return this.formatConfig != null && !(this.formatConfig instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatConfigAsStrings() {
        return this.formatConfig;
    }

    public final Integer widthPixels() {
        return this.widthPixels;
    }

    public final Integer heightPixels() {
        return this.heightPixels;
    }

    public final Long maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatConfig() ? this.formatConfigAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.widthPixels());
        hashCode = 31 * hashCode + Objects.hashCode(this.heightPixels());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImagesRequest)) {
            return false;
        }
        GetImagesRequest other = (GetImagesRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.imageSelectorTypeAsString(), other.imageSelectorTypeAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.samplingInterval(), other.samplingInterval()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasFormatConfig() == other.hasFormatConfig() && Objects.equals(this.formatConfigAsStrings(), other.formatConfigAsStrings()) && Objects.equals(this.widthPixels(), other.widthPixels()) && Objects.equals(this.heightPixels(), other.heightPixels()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetImagesRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("ImageSelectorType", (Object)this.imageSelectorTypeAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("SamplingInterval", (Object)this.samplingInterval()).add("Format", (Object)this.formatAsString()).add("FormatConfig", this.hasFormatConfig() ? this.formatConfigAsStrings() : null).add("WidthPixels", (Object)this.widthPixels()).add("HeightPixels", (Object)this.heightPixels()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ImageSelectorType": {
                return Optional.ofNullable(clazz.cast(this.imageSelectorTypeAsString()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "SamplingInterval": {
                return Optional.ofNullable(clazz.cast(this.samplingInterval()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "FormatConfig": {
                return Optional.ofNullable(clazz.cast(this.formatConfigAsStrings()));
            }
            case "WidthPixels": {
                return Optional.ofNullable(clazz.cast(this.widthPixels()));
            }
            case "HeightPixels": {
                return Optional.ofNullable(clazz.cast(this.heightPixels()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("ImageSelectorType", IMAGE_SELECTOR_TYPE_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("SamplingInterval", SAMPLING_INTERVAL_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("FormatConfig", FORMAT_CONFIG_FIELD);
        map.put("WidthPixels", WIDTH_PIXELS_FIELD);
        map.put("HeightPixels", HEIGHT_PIXELS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImagesRequest, T> g) {
        return obj -> g.apply((GetImagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String imageSelectorType;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private Integer samplingInterval;
        private String format;
        private Map<String, String> formatConfig = DefaultSdkAutoConstructMap.getInstance();
        private Integer widthPixels;
        private Integer heightPixels;
        private Long maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImagesRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.imageSelectorType(model.imageSelectorType);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.samplingInterval(model.samplingInterval);
            this.format(model.format);
            this.formatConfigWithStrings(model.formatConfig);
            this.widthPixels(model.widthPixels);
            this.heightPixels(model.heightPixels);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getImageSelectorType() {
            return this.imageSelectorType;
        }

        public final void setImageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
        }

        @Override
        public final Builder imageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
            return this;
        }

        @Override
        public final Builder imageSelectorType(ImageSelectorType imageSelectorType) {
            this.imageSelectorType(imageSelectorType == null ? null : imageSelectorType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final Integer getSamplingInterval() {
            return this.samplingInterval;
        }

        public final void setSamplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
        }

        @Override
        public final Builder samplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Map<String, String> getFormatConfig() {
            if (this.formatConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatConfig;
        }

        public final void setFormatConfig(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
        }

        @Override
        public final Builder formatConfigWithStrings(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
            return this;
        }

        @Override
        public final Builder formatConfig(Map<FormatConfigKey, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copyEnumToString(formatConfig);
            return this;
        }

        public final Integer getWidthPixels() {
            return this.widthPixels;
        }

        public final void setWidthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
        }

        @Override
        public final Builder widthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
            return this;
        }

        public final Integer getHeightPixels() {
            return this.heightPixels;
        }

        public final void setHeightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
        }

        @Override
        public final Builder heightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
            return this;
        }

        public final Long getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetImagesRequest build() {
            return new GetImagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImagesRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder imageSelectorType(String var1);

        public Builder imageSelectorType(ImageSelectorType var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder samplingInterval(Integer var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder formatConfigWithStrings(Map<String, String> var1);

        public Builder formatConfig(Map<FormatConfigKey, String> var1);

        public Builder widthPixels(Integer var1);

        public Builder heightPixels(Integer var1);

        public Builder maxResults(Long var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

