/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.DataKeyPairSpec;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataKeyPairWithoutPlaintextResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateDataKeyPairWithoutPlaintextResponse> {
    private static final SdkField<SdkBytes> PRIVATE_KEY_CIPHERTEXT_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("PrivateKeyCiphertextBlob").getter(GenerateDataKeyPairWithoutPlaintextResponse.getter(GenerateDataKeyPairWithoutPlaintextResponse::privateKeyCiphertextBlob)).setter(GenerateDataKeyPairWithoutPlaintextResponse.setter(Builder::privateKeyCiphertextBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyCiphertextBlob").build()}).build();
    private static final SdkField<SdkBytes> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("PublicKey").getter(GenerateDataKeyPairWithoutPlaintextResponse.getter(GenerateDataKeyPairWithoutPlaintextResponse::publicKey)).setter(GenerateDataKeyPairWithoutPlaintextResponse.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GenerateDataKeyPairWithoutPlaintextResponse.getter(GenerateDataKeyPairWithoutPlaintextResponse::keyId)).setter(GenerateDataKeyPairWithoutPlaintextResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_PAIR_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairSpec").getter(GenerateDataKeyPairWithoutPlaintextResponse.getter(GenerateDataKeyPairWithoutPlaintextResponse::keyPairSpecAsString)).setter(GenerateDataKeyPairWithoutPlaintextResponse.setter(Builder::keyPairSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_KEY_CIPHERTEXT_BLOB_FIELD, PUBLIC_KEY_FIELD, KEY_ID_FIELD, KEY_PAIR_SPEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateDataKeyPairWithoutPlaintextResponse.memberNameToFieldInitializer();
    private final SdkBytes privateKeyCiphertextBlob;
    private final SdkBytes publicKey;
    private final String keyId;
    private final String keyPairSpec;

    private GenerateDataKeyPairWithoutPlaintextResponse(BuilderImpl builder) {
        super(builder);
        this.privateKeyCiphertextBlob = builder.privateKeyCiphertextBlob;
        this.publicKey = builder.publicKey;
        this.keyId = builder.keyId;
        this.keyPairSpec = builder.keyPairSpec;
    }

    public final SdkBytes privateKeyCiphertextBlob() {
        return this.privateKeyCiphertextBlob;
    }

    public final SdkBytes publicKey() {
        return this.publicKey;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final DataKeyPairSpec keyPairSpec() {
        return DataKeyPairSpec.fromValue(this.keyPairSpec);
    }

    public final String keyPairSpecAsString() {
        return this.keyPairSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyCiphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairSpecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyPairWithoutPlaintextResponse)) {
            return false;
        }
        GenerateDataKeyPairWithoutPlaintextResponse other = (GenerateDataKeyPairWithoutPlaintextResponse)((Object)obj);
        return Objects.equals(this.privateKeyCiphertextBlob(), other.privateKeyCiphertextBlob()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyPairSpecAsString(), other.keyPairSpecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateDataKeyPairWithoutPlaintextResponse").add("PrivateKeyCiphertextBlob", (Object)this.privateKeyCiphertextBlob()).add("PublicKey", (Object)this.publicKey()).add("KeyId", (Object)this.keyId()).add("KeyPairSpec", (Object)this.keyPairSpecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrivateKeyCiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.privateKeyCiphertextBlob()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyPairSpec": {
                return Optional.ofNullable(clazz.cast(this.keyPairSpecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrivateKeyCiphertextBlob", PRIVATE_KEY_CIPHERTEXT_BLOB_FIELD);
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        map.put("KeyId", KEY_ID_FIELD);
        map.put("KeyPairSpec", KEY_PAIR_SPEC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataKeyPairWithoutPlaintextResponse, T> g) {
        return obj -> g.apply((GenerateDataKeyPairWithoutPlaintextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes privateKeyCiphertextBlob;
        private SdkBytes publicKey;
        private String keyId;
        private String keyPairSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyPairWithoutPlaintextResponse model) {
            super(model);
            this.privateKeyCiphertextBlob(model.privateKeyCiphertextBlob);
            this.publicKey(model.publicKey);
            this.keyId(model.keyId);
            this.keyPairSpec(model.keyPairSpec);
        }

        public final ByteBuffer getPrivateKeyCiphertextBlob() {
            return this.privateKeyCiphertextBlob == null ? null : this.privateKeyCiphertextBlob.asByteBuffer();
        }

        public final void setPrivateKeyCiphertextBlob(ByteBuffer privateKeyCiphertextBlob) {
            this.privateKeyCiphertextBlob(privateKeyCiphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)privateKeyCiphertextBlob));
        }

        @Override
        public final Builder privateKeyCiphertextBlob(SdkBytes privateKeyCiphertextBlob) {
            this.privateKeyCiphertextBlob = privateKeyCiphertextBlob;
            return this;
        }

        public final ByteBuffer getPublicKey() {
            return this.publicKey == null ? null : this.publicKey.asByteBuffer();
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey(publicKey == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)publicKey));
        }

        @Override
        public final Builder publicKey(SdkBytes publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyPairSpec() {
            return this.keyPairSpec;
        }

        public final void setKeyPairSpec(String keyPairSpec) {
            this.keyPairSpec = keyPairSpec;
        }

        @Override
        public final Builder keyPairSpec(String keyPairSpec) {
            this.keyPairSpec = keyPairSpec;
            return this;
        }

        @Override
        public final Builder keyPairSpec(DataKeyPairSpec keyPairSpec) {
            this.keyPairSpec(keyPairSpec == null ? null : keyPairSpec.toString());
            return this;
        }

        @Override
        public GenerateDataKeyPairWithoutPlaintextResponse build() {
            return new GenerateDataKeyPairWithoutPlaintextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateDataKeyPairWithoutPlaintextResponse> {
        public Builder privateKeyCiphertextBlob(SdkBytes var1);

        public Builder publicKey(SdkBytes var1);

        public Builder keyId(String var1);

        public Builder keyPairSpec(String var1);

        public Builder keyPairSpec(DataKeyPairSpec var1);
    }
}

