/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecryptResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, DecryptResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(DecryptResponse.getter(DecryptResponse::keyId)).setter(DecryptResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> PLAINTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Plaintext").getter(DecryptResponse.getter(DecryptResponse::plaintext)).setter(DecryptResponse.setter(Builder::plaintext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plaintext").build()}).build();
    private static final SdkField<String> ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionAlgorithm").getter(DecryptResponse.getter(DecryptResponse::encryptionAlgorithmAsString)).setter(DecryptResponse.setter(Builder::encryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAlgorithm").build()}).build();
    private static final SdkField<SdkBytes> CIPHERTEXT_FOR_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextForRecipient").getter(DecryptResponse.getter(DecryptResponse::ciphertextForRecipient)).setter(DecryptResponse.setter(Builder::ciphertextForRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextForRecipient").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, PLAINTEXT_FIELD, ENCRYPTION_ALGORITHM_FIELD, CIPHERTEXT_FOR_RECIPIENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecryptResponse.memberNameToFieldInitializer();
    private final String keyId;
    private final SdkBytes plaintext;
    private final String encryptionAlgorithm;
    private final SdkBytes ciphertextForRecipient;

    private DecryptResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.plaintext = builder.plaintext;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.ciphertextForRecipient = builder.ciphertextForRecipient;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final SdkBytes plaintext() {
        return this.plaintext;
    }

    public final EncryptionAlgorithmSpec encryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.encryptionAlgorithm);
    }

    public final String encryptionAlgorithmAsString() {
        return this.encryptionAlgorithm;
    }

    public final SdkBytes ciphertextForRecipient() {
        return this.ciphertextForRecipient;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.plaintext());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextForRecipient());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptResponse)) {
            return false;
        }
        DecryptResponse other = (DecryptResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.plaintext(), other.plaintext()) && Objects.equals(this.encryptionAlgorithmAsString(), other.encryptionAlgorithmAsString()) && Objects.equals(this.ciphertextForRecipient(), other.ciphertextForRecipient());
    }

    public final String toString() {
        return ToString.builder((String)"DecryptResponse").add("KeyId", (Object)this.keyId()).add("Plaintext", (Object)(this.plaintext() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionAlgorithm", (Object)this.encryptionAlgorithmAsString()).add("CiphertextForRecipient", (Object)this.ciphertextForRecipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Plaintext": {
                return Optional.ofNullable(clazz.cast(this.plaintext()));
            }
            case "EncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmAsString()));
            }
            case "CiphertextForRecipient": {
                return Optional.ofNullable(clazz.cast(this.ciphertextForRecipient()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("Plaintext", PLAINTEXT_FIELD);
        map.put("EncryptionAlgorithm", ENCRYPTION_ALGORITHM_FIELD);
        map.put("CiphertextForRecipient", CIPHERTEXT_FOR_RECIPIENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecryptResponse, T> g) {
        return obj -> g.apply((DecryptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes plaintext;
        private String encryptionAlgorithm;
        private SdkBytes ciphertextForRecipient;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.plaintext(model.plaintext);
            this.encryptionAlgorithm(model.encryptionAlgorithm);
            this.ciphertextForRecipient(model.ciphertextForRecipient);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext == null ? null : this.plaintext.asByteBuffer();
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext(plaintext == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)plaintext));
        }

        @Override
        public final Builder plaintext(SdkBytes plaintext) {
            this.plaintext = plaintext;
            return this;
        }

        public final String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public final void setEncryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        @Override
        public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder encryptionAlgorithm(EncryptionAlgorithmSpec encryptionAlgorithm) {
            this.encryptionAlgorithm(encryptionAlgorithm == null ? null : encryptionAlgorithm.toString());
            return this;
        }

        public final ByteBuffer getCiphertextForRecipient() {
            return this.ciphertextForRecipient == null ? null : this.ciphertextForRecipient.asByteBuffer();
        }

        public final void setCiphertextForRecipient(ByteBuffer ciphertextForRecipient) {
            this.ciphertextForRecipient(ciphertextForRecipient == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextForRecipient));
        }

        @Override
        public final Builder ciphertextForRecipient(SdkBytes ciphertextForRecipient) {
            this.ciphertextForRecipient = ciphertextForRecipient;
            return this;
        }

        @Override
        public DecryptResponse build() {
            return new DecryptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DecryptResponse> {
        public Builder keyId(String var1);

        public Builder plaintext(SdkBytes var1);

        public Builder encryptionAlgorithm(String var1);

        public Builder encryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public Builder ciphertextForRecipient(SdkBytes var1);
    }
}

