/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of failures when performing a batch grant or batch revoke operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPermissionsFailureEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchPermissionsFailureEntry.Builder, BatchPermissionsFailureEntry> {
    private static final SdkField<BatchPermissionsRequestEntry> REQUEST_ENTRY_FIELD = SdkField
            .<BatchPermissionsRequestEntry> builder(MarshallingType.SDK_POJO).memberName("RequestEntry")
            .getter(getter(BatchPermissionsFailureEntry::requestEntry)).setter(setter(Builder::requestEntry))
            .constructor(BatchPermissionsRequestEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestEntry").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(BatchPermissionsFailureEntry::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ENTRY_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchPermissionsRequestEntry requestEntry;

    private final ErrorDetail error;

    private BatchPermissionsFailureEntry(BuilderImpl builder) {
        this.requestEntry = builder.requestEntry;
        this.error = builder.error;
    }

    /**
     * <p>
     * An identifier for an entry of the batch request.
     * </p>
     * 
     * @return An identifier for an entry of the batch request.
     */
    public final BatchPermissionsRequestEntry requestEntry() {
        return requestEntry;
    }

    /**
     * <p>
     * An error message that applies to the failure of the entry.
     * </p>
     * 
     * @return An error message that applies to the failure of the entry.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestEntry());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPermissionsFailureEntry)) {
            return false;
        }
        BatchPermissionsFailureEntry other = (BatchPermissionsFailureEntry) obj;
        return Objects.equals(requestEntry(), other.requestEntry()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPermissionsFailureEntry").add("RequestEntry", requestEntry()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestEntry":
            return Optional.ofNullable(clazz.cast(requestEntry()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPermissionsFailureEntry, T> g) {
        return obj -> g.apply((BatchPermissionsFailureEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPermissionsFailureEntry> {
        /**
         * <p>
         * An identifier for an entry of the batch request.
         * </p>
         * 
         * @param requestEntry
         *        An identifier for an entry of the batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestEntry(BatchPermissionsRequestEntry requestEntry);

        /**
         * <p>
         * An identifier for an entry of the batch request.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchPermissionsRequestEntry.Builder} avoiding
         * the need to create one manually via {@link BatchPermissionsRequestEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchPermissionsRequestEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #requestEntry(BatchPermissionsRequestEntry)}.
         * 
         * @param requestEntry
         *        a consumer that will call methods on {@link BatchPermissionsRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestEntry(BatchPermissionsRequestEntry)
         */
        default Builder requestEntry(Consumer<BatchPermissionsRequestEntry.Builder> requestEntry) {
            return requestEntry(BatchPermissionsRequestEntry.builder().applyMutation(requestEntry).build());
        }

        /**
         * <p>
         * An error message that applies to the failure of the entry.
         * </p>
         * 
         * @param error
         *        An error message that applies to the failure of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error message that applies to the failure of the entry.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to create
         * one manually via {@link ErrorDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchPermissionsRequestEntry requestEntry;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPermissionsFailureEntry model) {
            requestEntry(model.requestEntry);
            error(model.error);
        }

        public final BatchPermissionsRequestEntry.Builder getRequestEntry() {
            return requestEntry != null ? requestEntry.toBuilder() : null;
        }

        public final void setRequestEntry(BatchPermissionsRequestEntry.BuilderImpl requestEntry) {
            this.requestEntry = requestEntry != null ? requestEntry.build() : null;
        }

        @Override
        @Transient
        public final Builder requestEntry(BatchPermissionsRequestEntry requestEntry) {
            this.requestEntry = requestEntry;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public BatchPermissionsFailureEntry build() {
            return new BatchPermissionsFailureEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
