/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterResourceRequest extends LakeFormationRequest implements
        ToCopyableBuilder<RegisterResourceRequest.Builder, RegisterResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(RegisterResourceRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Boolean> USE_SERVICE_LINKED_ROLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseServiceLinkedRole").getter(getter(RegisterResourceRequest::useServiceLinkedRole))
            .setter(setter(Builder::useServiceLinkedRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseServiceLinkedRole").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(RegisterResourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            USE_SERVICE_LINKED_ROLE_FIELD, ROLE_ARN_FIELD));

    private final String resourceArn;

    private final Boolean useServiceLinkedRole;

    private final String roleArn;

    private RegisterResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.useServiceLinkedRole = builder.useServiceLinkedRole;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you want to register.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that you want to register.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data
     * Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked Roles
     * for Lake Formation</a>.
     * </p>
     * 
     * @return Designates an Identity and Access Management (IAM) service-linked role by registering this role with the
     *         Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake
     *         Formation.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using
     *         Service-Linked Roles for Lake Formation</a>.
     */
    public final Boolean useServiceLinkedRole() {
        return useServiceLinkedRole;
    }

    /**
     * <p>
     * The identifier for the role that registers the resource.
     * </p>
     * 
     * @return The identifier for the role that registers the resource.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(useServiceLinkedRole());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterResourceRequest)) {
            return false;
        }
        RegisterResourceRequest other = (RegisterResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(useServiceLinkedRole(), other.useServiceLinkedRole())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterResourceRequest").add("ResourceArn", resourceArn())
                .add("UseServiceLinkedRole", useServiceLinkedRole()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "UseServiceLinkedRole":
            return Optional.ofNullable(clazz.cast(useServiceLinkedRole()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterResourceRequest, T> g) {
        return obj -> g.apply((RegisterResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource that you want to register.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource that you want to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Designates an Identity and Access Management (IAM) service-linked role by registering this role with the Data
         * Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake Formation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using Service-Linked
         * Roles for Lake Formation</a>.
         * </p>
         * 
         * @param useServiceLinkedRole
         *        Designates an Identity and Access Management (IAM) service-linked role by registering this role with
         *        the Data Catalog. A service-linked role is a unique type of IAM role that is linked directly to Lake
         *        Formation.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs-aws.amazon.com/lake-formation/latest/dg/service-linked-roles.html">Using
         *        Service-Linked Roles for Lake Formation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useServiceLinkedRole(Boolean useServiceLinkedRole);

        /**
         * <p>
         * The identifier for the role that registers the resource.
         * </p>
         * 
         * @param roleArn
         *        The identifier for the role that registers the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private Boolean useServiceLinkedRole;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            useServiceLinkedRole(model.useServiceLinkedRole);
            roleArn(model.roleArn);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getUseServiceLinkedRole() {
            return useServiceLinkedRole;
        }

        public final void setUseServiceLinkedRole(Boolean useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
        }

        @Override
        @Transient
        public final Builder useServiceLinkedRole(Boolean useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterResourceRequest build() {
            return new RegisterResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
