/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure describing the configuration and details of a storage optimizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageOptimizer implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageOptimizer.Builder, StorageOptimizer> {
    private static final SdkField<String> STORAGE_OPTIMIZER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageOptimizerType").getter(getter(StorageOptimizer::storageOptimizerTypeAsString))
            .setter(setter(Builder::storageOptimizerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageOptimizerType").build())
            .build();

    private static final SdkField<Map<String, String>> CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Config")
            .getter(getter(StorageOptimizer::config))
            .setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(StorageOptimizer::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> WARNINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Warnings").getter(getter(StorageOptimizer::warnings)).setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build()).build();

    private static final SdkField<String> LAST_RUN_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRunDetails").getter(getter(StorageOptimizer::lastRunDetails))
            .setter(setter(Builder::lastRunDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_OPTIMIZER_TYPE_FIELD,
            CONFIG_FIELD, ERROR_MESSAGE_FIELD, WARNINGS_FIELD, LAST_RUN_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageOptimizerType;

    private final Map<String, String> config;

    private final String errorMessage;

    private final String warnings;

    private final String lastRunDetails;

    private StorageOptimizer(BuilderImpl builder) {
        this.storageOptimizerType = builder.storageOptimizerType;
        this.config = builder.config;
        this.errorMessage = builder.errorMessage;
        this.warnings = builder.warnings;
        this.lastRunDetails = builder.lastRunDetails;
    }

    /**
     * <p>
     * The specific type of storage optimizer. The supported value is <code>compaction</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #storageOptimizerType} will return {@link OptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #storageOptimizerTypeAsString}.
     * </p>
     * 
     * @return The specific type of storage optimizer. The supported value is <code>compaction</code>.
     * @see OptimizerType
     */
    public final OptimizerType storageOptimizerType() {
        return OptimizerType.fromValue(storageOptimizerType);
    }

    /**
     * <p>
     * The specific type of storage optimizer. The supported value is <code>compaction</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #storageOptimizerType} will return {@link OptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #storageOptimizerTypeAsString}.
     * </p>
     * 
     * @return The specific type of storage optimizer. The supported value is <code>compaction</code>.
     * @see OptimizerType
     */
    public final String storageOptimizerTypeAsString() {
        return storageOptimizerType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Config property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfig() {
        return config != null && !(config instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the storage optimizer configuration. Currently contains only one key-value pair: <code>is_enabled</code>
     * indicates true or false for acceleration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfig} method.
     * </p>
     * 
     * @return A map of the storage optimizer configuration. Currently contains only one key-value pair:
     *         <code>is_enabled</code> indicates true or false for acceleration.
     */
    public final Map<String, String> config() {
        return config;
    }

    /**
     * <p>
     * A message that contains information about any error (if present).
     * </p>
     * <p>
     * When an acceleration result has an enabled status, the error message is empty.
     * </p>
     * <p>
     * When an acceleration result has a disabled status, the message describes an error or simply indicates
     * "disabled by the user".
     * </p>
     * 
     * @return A message that contains information about any error (if present).</p>
     *         <p>
     *         When an acceleration result has an enabled status, the error message is empty.
     *         </p>
     *         <p>
     *         When an acceleration result has a disabled status, the message describes an error or simply indicates
     *         "disabled by the user".
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * A message that contains information about any warnings (if present).
     * </p>
     * 
     * @return A message that contains information about any warnings (if present).
     */
    public final String warnings() {
        return warnings;
    }

    /**
     * <p>
     * When an acceleration result has an enabled status, contains the details of the last job run.
     * </p>
     * 
     * @return When an acceleration result has an enabled status, contains the details of the last job run.
     */
    public final String lastRunDetails() {
        return lastRunDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageOptimizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfig() ? config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageOptimizer)) {
            return false;
        }
        StorageOptimizer other = (StorageOptimizer) obj;
        return Objects.equals(storageOptimizerTypeAsString(), other.storageOptimizerTypeAsString())
                && hasConfig() == other.hasConfig() && Objects.equals(config(), other.config())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(warnings(), other.warnings())
                && Objects.equals(lastRunDetails(), other.lastRunDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageOptimizer").add("StorageOptimizerType", storageOptimizerTypeAsString())
                .add("Config", hasConfig() ? config() : null).add("ErrorMessage", errorMessage()).add("Warnings", warnings())
                .add("LastRunDetails", lastRunDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageOptimizerType":
            return Optional.ofNullable(clazz.cast(storageOptimizerTypeAsString()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        case "LastRunDetails":
            return Optional.ofNullable(clazz.cast(lastRunDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageOptimizer, T> g) {
        return obj -> g.apply((StorageOptimizer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageOptimizer> {
        /**
         * <p>
         * The specific type of storage optimizer. The supported value is <code>compaction</code>.
         * </p>
         * 
         * @param storageOptimizerType
         *        The specific type of storage optimizer. The supported value is <code>compaction</code>.
         * @see OptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizerType
         */
        Builder storageOptimizerType(String storageOptimizerType);

        /**
         * <p>
         * The specific type of storage optimizer. The supported value is <code>compaction</code>.
         * </p>
         * 
         * @param storageOptimizerType
         *        The specific type of storage optimizer. The supported value is <code>compaction</code>.
         * @see OptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizerType
         */
        Builder storageOptimizerType(OptimizerType storageOptimizerType);

        /**
         * <p>
         * A map of the storage optimizer configuration. Currently contains only one key-value pair:
         * <code>is_enabled</code> indicates true or false for acceleration.
         * </p>
         * 
         * @param config
         *        A map of the storage optimizer configuration. Currently contains only one key-value pair:
         *        <code>is_enabled</code> indicates true or false for acceleration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(Map<String, String> config);

        /**
         * <p>
         * A message that contains information about any error (if present).
         * </p>
         * <p>
         * When an acceleration result has an enabled status, the error message is empty.
         * </p>
         * <p>
         * When an acceleration result has a disabled status, the message describes an error or simply indicates
         * "disabled by the user".
         * </p>
         * 
         * @param errorMessage
         *        A message that contains information about any error (if present).</p>
         *        <p>
         *        When an acceleration result has an enabled status, the error message is empty.
         *        </p>
         *        <p>
         *        When an acceleration result has a disabled status, the message describes an error or simply indicates
         *        "disabled by the user".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * A message that contains information about any warnings (if present).
         * </p>
         * 
         * @param warnings
         *        A message that contains information about any warnings (if present).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String warnings);

        /**
         * <p>
         * When an acceleration result has an enabled status, contains the details of the last job run.
         * </p>
         * 
         * @param lastRunDetails
         *        When an acceleration result has an enabled status, contains the details of the last job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunDetails(String lastRunDetails);
    }

    static final class BuilderImpl implements Builder {
        private String storageOptimizerType;

        private Map<String, String> config = DefaultSdkAutoConstructMap.getInstance();

        private String errorMessage;

        private String warnings;

        private String lastRunDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageOptimizer model) {
            storageOptimizerType(model.storageOptimizerType);
            config(model.config);
            errorMessage(model.errorMessage);
            warnings(model.warnings);
            lastRunDetails(model.lastRunDetails);
        }

        public final String getStorageOptimizerType() {
            return storageOptimizerType;
        }

        public final void setStorageOptimizerType(String storageOptimizerType) {
            this.storageOptimizerType = storageOptimizerType;
        }

        @Override
        @Transient
        public final Builder storageOptimizerType(String storageOptimizerType) {
            this.storageOptimizerType = storageOptimizerType;
            return this;
        }

        @Override
        @Transient
        public final Builder storageOptimizerType(OptimizerType storageOptimizerType) {
            this.storageOptimizerType(storageOptimizerType == null ? null : storageOptimizerType.toString());
            return this;
        }

        public final Map<String, String> getConfig() {
            if (config instanceof SdkAutoConstructMap) {
                return null;
            }
            return config;
        }

        public final void setConfig(Map<String, String> config) {
            this.config = StorageOptimizerConfigCopier.copy(config);
        }

        @Override
        @Transient
        public final Builder config(Map<String, String> config) {
            this.config = StorageOptimizerConfigCopier.copy(config);
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getWarnings() {
            return warnings;
        }

        public final void setWarnings(String warnings) {
            this.warnings = warnings;
        }

        @Override
        @Transient
        public final Builder warnings(String warnings) {
            this.warnings = warnings;
            return this;
        }

        public final String getLastRunDetails() {
            return lastRunDetails;
        }

        public final void setLastRunDetails(String lastRunDetails) {
            this.lastRunDetails = lastRunDetails;
        }

        @Override
        @Transient
        public final Builder lastRunDetails(String lastRunDetails) {
            this.lastRunDetails = lastRunDetails;
            return this;
        }

        @Override
        public StorageOptimizer build() {
            return new StorageOptimizer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
