/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableObjectsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<UpdateTableObjectsRequest.Builder, UpdateTableObjectsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateTableObjectsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(UpdateTableObjectsRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateTableObjectsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(UpdateTableObjectsRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<List<WriteOperation>> WRITE_OPERATIONS_FIELD = SdkField
            .<List<WriteOperation>> builder(MarshallingType.LIST)
            .memberName("WriteOperations")
            .getter(getter(UpdateTableObjectsRequest::writeOperations))
            .setter(setter(Builder::writeOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WriteOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(WriteOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TRANSACTION_ID_FIELD, WRITE_OPERATIONS_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String transactionId;

    private final List<WriteOperation> writeOperations;

    private UpdateTableObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.transactionId = builder.transactionId;
        this.writeOperations = builder.writeOperations;
    }

    /**
     * <p>
     * The catalog containing the governed table to update. Defaults to the caller’s account ID.
     * </p>
     * 
     * @return The catalog containing the governed table to update. Defaults to the caller’s account ID.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The database containing the governed table to update.
     * </p>
     * 
     * @return The database containing the governed table to update.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The governed table to update.
     * </p>
     * 
     * @return The governed table to update.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The transaction at which to do the write.
     * </p>
     * 
     * @return The transaction at which to do the write.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the WriteOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWriteOperations() {
        return writeOperations != null && !(writeOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for a
     * governed table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWriteOperations} method.
     * </p>
     * 
     * @return A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest
     *         for a governed table.
     */
    public final List<WriteOperation> writeOperations() {
        return writeOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasWriteOperations() ? writeOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableObjectsRequest)) {
            return false;
        }
        UpdateTableObjectsRequest other = (UpdateTableObjectsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(transactionId(), other.transactionId())
                && hasWriteOperations() == other.hasWriteOperations()
                && Objects.equals(writeOperations(), other.writeOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableObjectsRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("TransactionId", transactionId())
                .add("WriteOperations", hasWriteOperations() ? writeOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "WriteOperations":
            return Optional.ofNullable(clazz.cast(writeOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableObjectsRequest, T> g) {
        return obj -> g.apply((UpdateTableObjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableObjectsRequest> {
        /**
         * <p>
         * The catalog containing the governed table to update. Defaults to the caller’s account ID.
         * </p>
         * 
         * @param catalogId
         *        The catalog containing the governed table to update. Defaults to the caller’s account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The database containing the governed table to update.
         * </p>
         * 
         * @param databaseName
         *        The database containing the governed table to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The governed table to update.
         * </p>
         * 
         * @param tableName
         *        The governed table to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The transaction at which to do the write.
         * </p>
         * 
         * @param transactionId
         *        The transaction at which to do the write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for
         * a governed table.
         * </p>
         * 
         * @param writeOperations
         *        A list of <code>WriteOperation</code> objects that define an object to add to or delete from the
         *        manifest for a governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeOperations(Collection<WriteOperation> writeOperations);

        /**
         * <p>
         * A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for
         * a governed table.
         * </p>
         * 
         * @param writeOperations
         *        A list of <code>WriteOperation</code> objects that define an object to add to or delete from the
         *        manifest for a governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeOperations(WriteOperation... writeOperations);

        /**
         * <p>
         * A list of <code>WriteOperation</code> objects that define an object to add to or delete from the manifest for
         * a governed table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WriteOperation>.Builder} avoiding the need
         * to create one manually via {@link List<WriteOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WriteOperation>.Builder#build()} is called immediately and
         * its result is passed to {@link #writeOperations(List<WriteOperation>)}.
         * 
         * @param writeOperations
         *        a consumer that will call methods on {@link List<WriteOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeOperations(List<WriteOperation>)
         */
        Builder writeOperations(Consumer<WriteOperation.Builder>... writeOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String transactionId;

        private List<WriteOperation> writeOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableObjectsRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            transactionId(model.transactionId);
            writeOperations(model.writeOperations);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        @Transient
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final List<WriteOperation.Builder> getWriteOperations() {
            List<WriteOperation.Builder> result = WriteOperationListCopier.copyToBuilder(this.writeOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWriteOperations(Collection<WriteOperation.BuilderImpl> writeOperations) {
            this.writeOperations = WriteOperationListCopier.copyFromBuilder(writeOperations);
        }

        @Override
        @Transient
        public final Builder writeOperations(Collection<WriteOperation> writeOperations) {
            this.writeOperations = WriteOperationListCopier.copy(writeOperations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder writeOperations(WriteOperation... writeOperations) {
            writeOperations(Arrays.asList(writeOperations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder writeOperations(Consumer<WriteOperation.Builder>... writeOperations) {
            writeOperations(Stream.of(writeOperations).map(c -> WriteOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableObjectsRequest build() {
            return new UpdateTableObjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
