/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkUnitsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, GetWorkUnitsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetWorkUnitsRequest.getter(GetWorkUnitsRequest::nextToken)).setter(GetWorkUnitsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(GetWorkUnitsRequest.getter(GetWorkUnitsRequest::pageSize)).setter(GetWorkUnitsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(GetWorkUnitsRequest.getter(GetWorkUnitsRequest::queryId)).setter(GetWorkUnitsRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, QUERY_ID_FIELD));
    private final String nextToken;
    private final Integer pageSize;
    private final String queryId;

    private GetWorkUnitsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.queryId = builder.queryId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String queryId() {
        return this.queryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkUnitsRequest)) {
            return false;
        }
        GetWorkUnitsRequest other = (GetWorkUnitsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.queryId(), other.queryId());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkUnitsRequest").add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).add("QueryId", (Object)this.queryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkUnitsRequest, T> g) {
        return obj -> g.apply((GetWorkUnitsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer pageSize;
        private String queryId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkUnitsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
            this.queryId(model.queryId);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        @Transient
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkUnitsRequest build() {
            return new GetWorkUnitsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkUnitsRequest> {
        public Builder nextToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder queryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

