/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.OperationUpdate;
import software.amazon.awssdk.services.lambda.model.OperationUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckpointDurableExecutionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CheckpointDurableExecutionRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurableExecutionArn").getter(CheckpointDurableExecutionRequest.getter(CheckpointDurableExecutionRequest::durableExecutionArn)).setter(CheckpointDurableExecutionRequest.setter(Builder::durableExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()}).build();
    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CheckpointToken").getter(CheckpointDurableExecutionRequest.getter(CheckpointDurableExecutionRequest::checkpointToken)).setter(CheckpointDurableExecutionRequest.setter(Builder::checkpointToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointToken").build()}).build();
    private static final SdkField<List<OperationUpdate>> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Updates").getter(CheckpointDurableExecutionRequest.getter(CheckpointDurableExecutionRequest::updates)).setter(CheckpointDurableExecutionRequest.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CheckpointDurableExecutionRequest.getter(CheckpointDurableExecutionRequest::clientToken)).setter(CheckpointDurableExecutionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD, CHECKPOINT_TOKEN_FIELD, UPDATES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckpointDurableExecutionRequest.memberNameToFieldInitializer();
    private final String durableExecutionArn;
    private final String checkpointToken;
    private final List<OperationUpdate> updates;
    private final String clientToken;

    private CheckpointDurableExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.checkpointToken = builder.checkpointToken;
        this.updates = builder.updates;
        this.clientToken = builder.clientToken;
    }

    public final String durableExecutionArn() {
        return this.durableExecutionArn;
    }

    public final String checkpointToken() {
        return this.checkpointToken;
    }

    public final boolean hasUpdates() {
        return this.updates != null && !(this.updates instanceof SdkAutoConstructList);
    }

    public final List<OperationUpdate> updates() {
        return this.updates;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdates() ? this.updates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckpointDurableExecutionRequest)) {
            return false;
        }
        CheckpointDurableExecutionRequest other = (CheckpointDurableExecutionRequest)((Object)obj);
        return Objects.equals(this.durableExecutionArn(), other.durableExecutionArn()) && Objects.equals(this.checkpointToken(), other.checkpointToken()) && this.hasUpdates() == other.hasUpdates() && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CheckpointDurableExecutionRequest").add("DurableExecutionArn", (Object)this.durableExecutionArn()).add("CheckpointToken", (Object)this.checkpointToken()).add("Updates", this.hasUpdates() ? this.updates() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurableExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.durableExecutionArn()));
            }
            case "CheckpointToken": {
                return Optional.ofNullable(clazz.cast(this.checkpointToken()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("Updates", UPDATES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckpointDurableExecutionRequest, T> g) {
        return obj -> g.apply((CheckpointDurableExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String durableExecutionArn;
        private String checkpointToken;
        private List<OperationUpdate> updates = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckpointDurableExecutionRequest model) {
            super(model);
            this.durableExecutionArn(model.durableExecutionArn);
            this.checkpointToken(model.checkpointToken);
            this.updates(model.updates);
            this.clientToken(model.clientToken);
        }

        public final String getDurableExecutionArn() {
            return this.durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getCheckpointToken() {
            return this.checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final List<OperationUpdate.Builder> getUpdates() {
            List<OperationUpdate.Builder> result = OperationUpdatesCopier.copyToBuilder(this.updates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdates(Collection<OperationUpdate.BuilderImpl> updates) {
            this.updates = OperationUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public final Builder updates(Collection<OperationUpdate> updates) {
            this.updates = OperationUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(OperationUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(Consumer<OperationUpdate.Builder> ... updates) {
            this.updates(Stream.of(updates).map(c -> (OperationUpdate)((OperationUpdate.Builder)OperationUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckpointDurableExecutionRequest build() {
            return new CheckpointDurableExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckpointDurableExecutionRequest> {
        public Builder durableExecutionArn(String var1);

        public Builder checkpointToken(String var1);

        public Builder updates(Collection<OperationUpdate> var1);

        public Builder updates(OperationUpdate ... var1);

        public Builder updates(Consumer<OperationUpdate.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

