/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.CapacityProvider;
import software.amazon.awssdk.services.lambda.model.CapacityProvidersListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCapacityProvidersResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListCapacityProvidersResponse> {
    private static final SdkField<List<CapacityProvider>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityProviders").getter(ListCapacityProvidersResponse.getter(ListCapacityProvidersResponse::capacityProviders)).setter(ListCapacityProvidersResponse.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListCapacityProvidersResponse.getter(ListCapacityProvidersResponse::nextMarker)).setter(ListCapacityProvidersResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCapacityProvidersResponse.memberNameToFieldInitializer();
    private final List<CapacityProvider> capacityProviders;
    private final String nextMarker;

    private ListCapacityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProviders = builder.capacityProviders;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<CapacityProvider> capacityProviders() {
        return this.capacityProviders;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityProvidersResponse)) {
            return false;
        }
        ListCapacityProvidersResponse other = (ListCapacityProvidersResponse)((Object)obj);
        return this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListCapacityProvidersResponse").add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviders", CAPACITY_PROVIDERS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityProvidersResponse, T> g) {
        return obj -> g.apply((ListCapacityProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<CapacityProvider> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityProvidersResponse model) {
            super(model);
            this.capacityProviders(model.capacityProviders);
            this.nextMarker(model.nextMarker);
        }

        public final List<CapacityProvider.Builder> getCapacityProviders() {
            List<CapacityProvider.Builder> result = CapacityProvidersListCopier.copyToBuilder(this.capacityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviders(Collection<CapacityProvider.BuilderImpl> capacityProviders) {
            this.capacityProviders = CapacityProvidersListCopier.copyFromBuilder(capacityProviders);
        }

        @Override
        public final Builder capacityProviders(Collection<CapacityProvider> capacityProviders) {
            this.capacityProviders = CapacityProvidersListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(CapacityProvider ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(Consumer<CapacityProvider.Builder> ... capacityProviders) {
            this.capacityProviders(Stream.of(capacityProviders).map(c -> (CapacityProvider)((CapacityProvider.Builder)CapacityProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListCapacityProvidersResponse build() {
            return new ListCapacityProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCapacityProvidersResponse> {
        public Builder capacityProviders(Collection<CapacityProvider> var1);

        public Builder capacityProviders(CapacityProvider ... var1);

        public Builder capacityProviders(Consumer<CapacityProvider.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

