/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.launchwizard.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentDataSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DeploymentDataSummary.getter(DeploymentDataSummary::createdAt)).setter(DeploymentDataSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeploymentDataSummary.getter(DeploymentDataSummary::id)).setter(DeploymentDataSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeploymentDataSummary.getter(DeploymentDataSummary::name)).setter(DeploymentDataSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternName").getter(DeploymentDataSummary.getter(DeploymentDataSummary::patternName)).setter(DeploymentDataSummary.setter(Builder::patternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeploymentDataSummary.getter(DeploymentDataSummary::statusAsString)).setter(DeploymentDataSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(DeploymentDataSummary.getter(DeploymentDataSummary::workloadName)).setter(DeploymentDataSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ID_FIELD, NAME_FIELD, PATTERN_NAME_FIELD, STATUS_FIELD, WORKLOAD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentDataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String id;
    private final String name;
    private final String patternName;
    private final String status;
    private final String workloadName;

    private DeploymentDataSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.name = builder.name;
        this.patternName = builder.patternName;
        this.status = builder.status;
        this.workloadName = builder.workloadName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String patternName() {
        return this.patternName;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentDataSummary)) {
            return false;
        }
        DeploymentDataSummary other = (DeploymentDataSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.patternName(), other.patternName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentDataSummary").add("CreatedAt", (Object)this.createdAt()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("PatternName", (Object)this.patternName()).add("Status", (Object)this.statusAsString()).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "patternName": {
                return Optional.ofNullable(clazz.cast(this.patternName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("patternName", PATTERN_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentDataSummary, T> g) {
        return obj -> g.apply((DeploymentDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String id;
        private String name;
        private String patternName;
        private String status;
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentDataSummary model) {
            this.createdAt(model.createdAt);
            this.id(model.id);
            this.name(model.name);
            this.patternName(model.patternName);
            this.status(model.status);
            this.workloadName(model.workloadName);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPatternName() {
            return this.patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public DeploymentDataSummary build() {
            return new DeploymentDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentDataSummary> {
        public Builder createdAt(Instant var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder patternName(String var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder workloadName(String var1);
    }
}

