/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsCopier;
import software.amazon.awssdk.services.launchwizard.model.DeploymentStatus;
import software.amazon.awssdk.services.launchwizard.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentData> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DeploymentData.getter(DeploymentData::createdAt)).setter(DeploymentData.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deletedAt").getter(DeploymentData.getter(DeploymentData::deletedAt)).setter(DeploymentData.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentArn").getter(DeploymentData.getter(DeploymentData::deploymentArn)).setter(DeploymentData.setter(Builder::deploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentArn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeploymentData.getter(DeploymentData::id)).setter(DeploymentData.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeploymentData.getter(DeploymentData::name)).setter(DeploymentData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patternName").getter(DeploymentData.getter(DeploymentData::patternName)).setter(DeploymentData.setter(Builder::patternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternName").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGroup").getter(DeploymentData.getter(DeploymentData::resourceGroup)).setter(DeploymentData.setter(Builder::resourceGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroup").build()}).build();
    private static final SdkField<Map<String, String>> SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("specifications").getter(DeploymentData.getter(DeploymentData::specifications)).setter(DeploymentData.setter(Builder::specifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeploymentData.getter(DeploymentData::statusAsString)).setter(DeploymentData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DeploymentData.getter(DeploymentData::tags)).setter(DeploymentData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(DeploymentData.getter(DeploymentData::workloadName)).setter(DeploymentData.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DELETED_AT_FIELD, DEPLOYMENT_ARN_FIELD, ID_FIELD, NAME_FIELD, PATTERN_NAME_FIELD, RESOURCE_GROUP_FIELD, SPECIFICATIONS_FIELD, STATUS_FIELD, TAGS_FIELD, WORKLOAD_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final Instant deletedAt;
    private final String deploymentArn;
    private final String id;
    private final String name;
    private final String patternName;
    private final String resourceGroup;
    private final Map<String, String> specifications;
    private final String status;
    private final Map<String, String> tags;
    private final String workloadName;

    private DeploymentData(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
        this.deploymentArn = builder.deploymentArn;
        this.id = builder.id;
        this.name = builder.name;
        this.patternName = builder.patternName;
        this.resourceGroup = builder.resourceGroup;
        this.specifications = builder.specifications;
        this.status = builder.status;
        this.tags = builder.tags;
        this.workloadName = builder.workloadName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final String deploymentArn() {
        return this.deploymentArn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String patternName() {
        return this.patternName;
    }

    public final String resourceGroup() {
        return this.resourceGroup;
    }

    public final boolean hasSpecifications() {
        return this.specifications != null && !(this.specifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> specifications() {
        return this.specifications;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecifications() ? this.specifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentData)) {
            return false;
        }
        DeploymentData other = (DeploymentData)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.deploymentArn(), other.deploymentArn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.patternName(), other.patternName()) && Objects.equals(this.resourceGroup(), other.resourceGroup()) && this.hasSpecifications() == other.hasSpecifications() && Objects.equals(this.specifications(), other.specifications()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentData").add("CreatedAt", (Object)this.createdAt()).add("DeletedAt", (Object)this.deletedAt()).add("DeploymentArn", (Object)this.deploymentArn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("PatternName", (Object)this.patternName()).add("ResourceGroup", (Object)this.resourceGroup()).add("Specifications", (Object)(this.specifications() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "deploymentArn": {
                return Optional.ofNullable(clazz.cast(this.deploymentArn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "patternName": {
                return Optional.ofNullable(clazz.cast(this.patternName()));
            }
            case "resourceGroup": {
                return Optional.ofNullable(clazz.cast(this.resourceGroup()));
            }
            case "specifications": {
                return Optional.ofNullable(clazz.cast(this.specifications()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("deletedAt", DELETED_AT_FIELD);
        map.put("deploymentArn", DEPLOYMENT_ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("patternName", PATTERN_NAME_FIELD);
        map.put("resourceGroup", RESOURCE_GROUP_FIELD);
        map.put("specifications", SPECIFICATIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentData, T> g) {
        return obj -> g.apply((DeploymentData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private Instant deletedAt;
        private String deploymentArn;
        private String id;
        private String name;
        private String patternName;
        private String resourceGroup;
        private Map<String, String> specifications = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentData model) {
            this.createdAt(model.createdAt);
            this.deletedAt(model.deletedAt);
            this.deploymentArn(model.deploymentArn);
            this.id(model.id);
            this.name(model.name);
            this.patternName(model.patternName);
            this.resourceGroup(model.resourceGroup);
            this.specifications(model.specifications);
            this.status(model.status);
            this.tags(model.tags);
            this.workloadName(model.workloadName);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getDeploymentArn() {
            return this.deploymentArn;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPatternName() {
            return this.patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getResourceGroup() {
            return this.resourceGroup;
        }

        public final void setResourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        @Override
        public final Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public final Map<String, String> getSpecifications() {
            if (this.specifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.specifications;
        }

        public final void setSpecifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
        }

        @Override
        public final Builder specifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public DeploymentData build() {
            return new DeploymentData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentData> {
        public Builder createdAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder deploymentArn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder patternName(String var1);

        public Builder resourceGroup(String var1);

        public Builder specifications(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder workloadName(String var1);
    }
}

