/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;

public class GetIntentVersionsIterable
implements SdkIterable<GetIntentVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIntentVersionsIterable(LexModelBuildingClient client, GetIntentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIntentVersionsResponseFetcher();
    }

    public Iterator<GetIntentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetIntentVersionsResponseFetcher
    implements SyncPageFetcher<GetIntentVersionsResponse> {
        private GetIntentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIntentVersionsResponse nextPage(GetIntentVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentVersionsIterable.this.client.getIntentVersions(GetIntentVersionsIterable.this.firstRequest);
            }
            return GetIntentVersionsIterable.this.client.getIntentVersions((GetIntentVersionsRequest)((Object)GetIntentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

