/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MigrationAlertType {
    ERROR("ERROR"),
    WARN("WARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MigrationAlertType> VALUE_MAP;
    private final String value;

    private MigrationAlertType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationAlertType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationAlertType> knownValues() {
        EnumSet<MigrationAlertType> knownValues = EnumSet.allOf(MigrationAlertType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MigrationAlertType.class, MigrationAlertType::toString);
    }
}

