/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the external source of the slot type's definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalSourceSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalSourceSetting.Builder, ExternalSourceSetting> {
    private static final SdkField<GrammarSlotTypeSetting> GRAMMAR_SLOT_TYPE_SETTING_FIELD = SdkField
            .<GrammarSlotTypeSetting> builder(MarshallingType.SDK_POJO).memberName("grammarSlotTypeSetting")
            .getter(getter(ExternalSourceSetting::grammarSlotTypeSetting)).setter(setter(Builder::grammarSlotTypeSetting))
            .constructor(GrammarSlotTypeSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grammarSlotTypeSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GRAMMAR_SLOT_TYPE_SETTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrammarSlotTypeSetting grammarSlotTypeSetting;

    private ExternalSourceSetting(BuilderImpl builder) {
        this.grammarSlotTypeSetting = builder.grammarSlotTypeSetting;
    }

    /**
     * <p>
     * Settings required for a slot type based on a grammar that you provide.
     * </p>
     * 
     * @return Settings required for a slot type based on a grammar that you provide.
     */
    public final GrammarSlotTypeSetting grammarSlotTypeSetting() {
        return grammarSlotTypeSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grammarSlotTypeSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourceSetting)) {
            return false;
        }
        ExternalSourceSetting other = (ExternalSourceSetting) obj;
        return Objects.equals(grammarSlotTypeSetting(), other.grammarSlotTypeSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalSourceSetting").add("GrammarSlotTypeSetting", grammarSlotTypeSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grammarSlotTypeSetting":
            return Optional.ofNullable(clazz.cast(grammarSlotTypeSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourceSetting, T> g) {
        return obj -> g.apply((ExternalSourceSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalSourceSetting> {
        /**
         * <p>
         * Settings required for a slot type based on a grammar that you provide.
         * </p>
         * 
         * @param grammarSlotTypeSetting
         *        Settings required for a slot type based on a grammar that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grammarSlotTypeSetting(GrammarSlotTypeSetting grammarSlotTypeSetting);

        /**
         * <p>
         * Settings required for a slot type based on a grammar that you provide.
         * </p>
         * This is a convenience that creates an instance of the {@link GrammarSlotTypeSetting.Builder} avoiding the
         * need to create one manually via {@link GrammarSlotTypeSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrammarSlotTypeSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #grammarSlotTypeSetting(GrammarSlotTypeSetting)}.
         * 
         * @param grammarSlotTypeSetting
         *        a consumer that will call methods on {@link GrammarSlotTypeSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grammarSlotTypeSetting(GrammarSlotTypeSetting)
         */
        default Builder grammarSlotTypeSetting(Consumer<GrammarSlotTypeSetting.Builder> grammarSlotTypeSetting) {
            return grammarSlotTypeSetting(GrammarSlotTypeSetting.builder().applyMutation(grammarSlotTypeSetting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrammarSlotTypeSetting grammarSlotTypeSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourceSetting model) {
            grammarSlotTypeSetting(model.grammarSlotTypeSetting);
        }

        public final GrammarSlotTypeSetting.Builder getGrammarSlotTypeSetting() {
            return grammarSlotTypeSetting != null ? grammarSlotTypeSetting.toBuilder() : null;
        }

        public final void setGrammarSlotTypeSetting(GrammarSlotTypeSetting.BuilderImpl grammarSlotTypeSetting) {
            this.grammarSlotTypeSetting = grammarSlotTypeSetting != null ? grammarSlotTypeSetting.build() : null;
        }

        @Override
        @Transient
        public final Builder grammarSlotTypeSetting(GrammarSlotTypeSetting grammarSlotTypeSetting) {
            this.grammarSlotTypeSetting = grammarSlotTypeSetting;
            return this;
        }

        @Override
        public ExternalSourceSetting build() {
            return new ExternalSourceSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
