/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines if a Lambda function should be invoked for a specific intent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FulfillmentCodeHookSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FulfillmentCodeHookSettings.Builder, FulfillmentCodeHookSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(FulfillmentCodeHookSettings::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<PostFulfillmentStatusSpecification> POST_FULFILLMENT_STATUS_SPECIFICATION_FIELD = SdkField
            .<PostFulfillmentStatusSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("postFulfillmentStatusSpecification")
            .getter(getter(FulfillmentCodeHookSettings::postFulfillmentStatusSpecification))
            .setter(setter(Builder::postFulfillmentStatusSpecification))
            .constructor(PostFulfillmentStatusSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFulfillmentStatusSpecification")
                    .build()).build();

    private static final SdkField<FulfillmentUpdatesSpecification> FULFILLMENT_UPDATES_SPECIFICATION_FIELD = SdkField
            .<FulfillmentUpdatesSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("fulfillmentUpdatesSpecification")
            .getter(getter(FulfillmentCodeHookSettings::fulfillmentUpdatesSpecification))
            .setter(setter(Builder::fulfillmentUpdatesSpecification))
            .constructor(FulfillmentUpdatesSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentUpdatesSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            POST_FULFILLMENT_STATUS_SPECIFICATION_FIELD, FULFILLMENT_UPDATES_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final PostFulfillmentStatusSpecification postFulfillmentStatusSpecification;

    private final FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification;

    private FulfillmentCodeHookSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.postFulfillmentStatusSpecification = builder.postFulfillmentStatusSpecification;
        this.fulfillmentUpdatesSpecification = builder.fulfillmentUpdatesSpecification;
    }

    /**
     * <p>
     * Indicates whether a Lambda function should be invoked to fulfill a specific intent.
     * </p>
     * 
     * @return Indicates whether a Lambda function should be invoked to fulfill a specific intent.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
     * Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
     * </p>
     * 
     * @return Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
     *         Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
     */
    public final PostFulfillmentStatusSpecification postFulfillmentStatusSpecification() {
        return postFulfillmentStatusSpecification;
    }

    /**
     * <p>
     * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment
     * updates can be used only with streaming conversations.
     * </p>
     * 
     * @return Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
     *         Fulfillment updates can be used only with streaming conversations.
     */
    public final FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification() {
        return fulfillmentUpdatesSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(postFulfillmentStatusSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentUpdatesSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentCodeHookSettings)) {
            return false;
        }
        FulfillmentCodeHookSettings other = (FulfillmentCodeHookSettings) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(postFulfillmentStatusSpecification(), other.postFulfillmentStatusSpecification())
                && Objects.equals(fulfillmentUpdatesSpecification(), other.fulfillmentUpdatesSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FulfillmentCodeHookSettings").add("Enabled", enabled())
                .add("PostFulfillmentStatusSpecification", postFulfillmentStatusSpecification())
                .add("FulfillmentUpdatesSpecification", fulfillmentUpdatesSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "postFulfillmentStatusSpecification":
            return Optional.ofNullable(clazz.cast(postFulfillmentStatusSpecification()));
        case "fulfillmentUpdatesSpecification":
            return Optional.ofNullable(clazz.cast(fulfillmentUpdatesSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FulfillmentCodeHookSettings, T> g) {
        return obj -> g.apply((FulfillmentCodeHookSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FulfillmentCodeHookSettings> {
        /**
         * <p>
         * Indicates whether a Lambda function should be invoked to fulfill a specific intent.
         * </p>
         * 
         * @param enabled
         *        Indicates whether a Lambda function should be invoked to fulfill a specific intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
         * Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         * </p>
         * 
         * @param postFulfillmentStatusSpecification
         *        Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
         *        Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification postFulfillmentStatusSpecification);

        /**
         * <p>
         * Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
         * Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         * </p>
         * This is a convenience that creates an instance of the {@link PostFulfillmentStatusSpecification.Builder}
         * avoiding the need to create one manually via {@link PostFulfillmentStatusSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PostFulfillmentStatusSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification)}.
         * 
         * @param postFulfillmentStatusSpecification
         *        a consumer that will call methods on {@link PostFulfillmentStatusSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification)
         */
        default Builder postFulfillmentStatusSpecification(
                Consumer<PostFulfillmentStatusSpecification.Builder> postFulfillmentStatusSpecification) {
            return postFulfillmentStatusSpecification(PostFulfillmentStatusSpecification.builder()
                    .applyMutation(postFulfillmentStatusSpecification).build());
        }

        /**
         * <p>
         * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
         * Fulfillment updates can be used only with streaming conversations.
         * </p>
         * 
         * @param fulfillmentUpdatesSpecification
         *        Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
         *        Fulfillment updates can be used only with streaming conversations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification);

        /**
         * <p>
         * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
         * Fulfillment updates can be used only with streaming conversations.
         * </p>
         * This is a convenience that creates an instance of the {@link FulfillmentUpdatesSpecification.Builder}
         * avoiding the need to create one manually via {@link FulfillmentUpdatesSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link FulfillmentUpdatesSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification)}.
         * 
         * @param fulfillmentUpdatesSpecification
         *        a consumer that will call methods on {@link FulfillmentUpdatesSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification)
         */
        default Builder fulfillmentUpdatesSpecification(
                Consumer<FulfillmentUpdatesSpecification.Builder> fulfillmentUpdatesSpecification) {
            return fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification.builder()
                    .applyMutation(fulfillmentUpdatesSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private PostFulfillmentStatusSpecification postFulfillmentStatusSpecification;

        private FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentCodeHookSettings model) {
            enabled(model.enabled);
            postFulfillmentStatusSpecification(model.postFulfillmentStatusSpecification);
            fulfillmentUpdatesSpecification(model.fulfillmentUpdatesSpecification);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final PostFulfillmentStatusSpecification.Builder getPostFulfillmentStatusSpecification() {
            return postFulfillmentStatusSpecification != null ? postFulfillmentStatusSpecification.toBuilder() : null;
        }

        public final void setPostFulfillmentStatusSpecification(
                PostFulfillmentStatusSpecification.BuilderImpl postFulfillmentStatusSpecification) {
            this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification != null ? postFulfillmentStatusSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder postFulfillmentStatusSpecification(
                PostFulfillmentStatusSpecification postFulfillmentStatusSpecification) {
            this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
            return this;
        }

        public final FulfillmentUpdatesSpecification.Builder getFulfillmentUpdatesSpecification() {
            return fulfillmentUpdatesSpecification != null ? fulfillmentUpdatesSpecification.toBuilder() : null;
        }

        public final void setFulfillmentUpdatesSpecification(
                FulfillmentUpdatesSpecification.BuilderImpl fulfillmentUpdatesSpecification) {
            this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification != null ? fulfillmentUpdatesSpecification
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecification fulfillmentUpdatesSpecification) {
            this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
            return this;
        }

        @Override
        public FulfillmentCodeHookSettings build() {
            return new FulfillmentCodeHookSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
