/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that contains the statistical summary of the recommended slot type associated with the bot recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotTypeStatistics.Builder, SlotTypeStatistics> {
    private static final SdkField<Integer> DISCOVERED_SLOT_TYPE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("discoveredSlotTypeCount").getter(getter(SlotTypeStatistics::discoveredSlotTypeCount))
            .setter(setter(Builder::discoveredSlotTypeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveredSlotTypeCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISCOVERED_SLOT_TYPE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer discoveredSlotTypeCount;

    private SlotTypeStatistics(BuilderImpl builder) {
        this.discoveredSlotTypeCount = builder.discoveredSlotTypeCount;
    }

    /**
     * <p>
     * The number of recommended slot types associated with the bot recommendation.
     * </p>
     * 
     * @return The number of recommended slot types associated with the bot recommendation.
     */
    public final Integer discoveredSlotTypeCount() {
        return discoveredSlotTypeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveredSlotTypeCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeStatistics)) {
            return false;
        }
        SlotTypeStatistics other = (SlotTypeStatistics) obj;
        return Objects.equals(discoveredSlotTypeCount(), other.discoveredSlotTypeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeStatistics").add("DiscoveredSlotTypeCount", discoveredSlotTypeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "discoveredSlotTypeCount":
            return Optional.ofNullable(clazz.cast(discoveredSlotTypeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeStatistics, T> g) {
        return obj -> g.apply((SlotTypeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeStatistics> {
        /**
         * <p>
         * The number of recommended slot types associated with the bot recommendation.
         * </p>
         * 
         * @param discoveredSlotTypeCount
         *        The number of recommended slot types associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveredSlotTypeCount(Integer discoveredSlotTypeCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer discoveredSlotTypeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeStatistics model) {
            discoveredSlotTypeCount(model.discoveredSlotTypeCount);
        }

        public final Integer getDiscoveredSlotTypeCount() {
            return discoveredSlotTypeCount;
        }

        public final void setDiscoveredSlotTypeCount(Integer discoveredSlotTypeCount) {
            this.discoveredSlotTypeCount = discoveredSlotTypeCount;
        }

        @Override
        @Transient
        public final Builder discoveredSlotTypeCount(Integer discoveredSlotTypeCount) {
            this.discoveredSlotTypeCount = discoveredSlotTypeCount;
            return this;
        }

        @Override
        public SlotTypeStatistics build() {
            return new SlotTypeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
