/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AggregatedUtterancesSortBy;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceAggregationDuration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAggregatedUtterancesRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListAggregatedUtterancesRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::botId)).setter(ListAggregatedUtterancesRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::botAliasId)).setter(ListAggregatedUtterancesRequest.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::botVersion)).setter(ListAggregatedUtterancesRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::localeId)).setter(ListAggregatedUtterancesRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<UtteranceAggregationDuration> AGGREGATION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregationDuration").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::aggregationDuration)).setter(ListAggregatedUtterancesRequest.setter(Builder::aggregationDuration)).constructor(UtteranceAggregationDuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build()}).build();
    private static final SdkField<AggregatedUtterancesSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::sortBy)).setter(ListAggregatedUtterancesRequest.setter(Builder::sortBy)).constructor(AggregatedUtterancesSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<List<AggregatedUtterancesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::filters)).setter(ListAggregatedUtterancesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedUtterancesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::maxResults)).setter(ListAggregatedUtterancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAggregatedUtterancesRequest.getter(ListAggregatedUtterancesRequest::nextToken)).setter(ListAggregatedUtterancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, AGGREGATION_DURATION_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final String botAliasId;
    private final String botVersion;
    private final String localeId;
    private final UtteranceAggregationDuration aggregationDuration;
    private final AggregatedUtterancesSortBy sortBy;
    private final List<AggregatedUtterancesFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListAggregatedUtterancesRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.aggregationDuration = builder.aggregationDuration;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final UtteranceAggregationDuration aggregationDuration() {
        return this.aggregationDuration;
    }

    public final AggregatedUtterancesSortBy sortBy() {
        return this.sortBy;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AggregatedUtterancesFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatedUtterancesRequest)) {
            return false;
        }
        ListAggregatedUtterancesRequest other = (ListAggregatedUtterancesRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.aggregationDuration(), other.aggregationDuration()) && Objects.equals(this.sortBy(), other.sortBy()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAggregatedUtterancesRequest").add("BotId", (Object)this.botId()).add("BotAliasId", (Object)this.botAliasId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("AggregationDuration", (Object)this.aggregationDuration()).add("SortBy", (Object)this.sortBy()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "aggregationDuration": {
                return Optional.ofNullable(clazz.cast(this.aggregationDuration()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatedUtterancesRequest, T> g) {
        return obj -> g.apply((ListAggregatedUtterancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botAliasId;
        private String botVersion;
        private String localeId;
        private UtteranceAggregationDuration aggregationDuration;
        private AggregatedUtterancesSortBy sortBy;
        private List<AggregatedUtterancesFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatedUtterancesRequest model) {
            super(model);
            this.botId(model.botId);
            this.botAliasId(model.botAliasId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.aggregationDuration(model.aggregationDuration);
            this.sortBy(model.sortBy);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        @Transient
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final UtteranceAggregationDuration.Builder getAggregationDuration() {
            return this.aggregationDuration != null ? this.aggregationDuration.toBuilder() : null;
        }

        public final void setAggregationDuration(UtteranceAggregationDuration.BuilderImpl aggregationDuration) {
            this.aggregationDuration = aggregationDuration != null ? aggregationDuration.build() : null;
        }

        @Override
        @Transient
        public final Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        public final AggregatedUtterancesSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(AggregatedUtterancesSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        @Transient
        public final Builder sortBy(AggregatedUtterancesSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<AggregatedUtterancesFilter.Builder> getFilters() {
            List<AggregatedUtterancesFilter.Builder> result = AggregatedUtterancesFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AggregatedUtterancesFilter.BuilderImpl> filters) {
            this.filters = AggregatedUtterancesFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<AggregatedUtterancesFilter> filters) {
            this.filters = AggregatedUtterancesFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(AggregatedUtterancesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<AggregatedUtterancesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AggregatedUtterancesFilter)((AggregatedUtterancesFilter.Builder)AggregatedUtterancesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAggregatedUtterancesRequest build() {
            return new ListAggregatedUtterancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAggregatedUtterancesRequest> {
        public Builder botId(String var1);

        public Builder botAliasId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder aggregationDuration(UtteranceAggregationDuration var1);

        default public Builder aggregationDuration(Consumer<UtteranceAggregationDuration.Builder> aggregationDuration) {
            return this.aggregationDuration((UtteranceAggregationDuration)((UtteranceAggregationDuration.Builder)UtteranceAggregationDuration.builder().applyMutation(aggregationDuration)).build());
        }

        public Builder sortBy(AggregatedUtterancesSortBy var1);

        default public Builder sortBy(Consumer<AggregatedUtterancesSortBy.Builder> sortBy) {
            return this.sortBy((AggregatedUtterancesSortBy)((AggregatedUtterancesSortBy.Builder)AggregatedUtterancesSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder filters(Collection<AggregatedUtterancesFilter> var1);

        public Builder filters(AggregatedUtterancesFilter ... var1);

        public Builder filters(Consumer<AggregatedUtterancesFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

