/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.DialogCodeHookSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.FulfillmentCodeHookSettings;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContextsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentClosingSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.KendraConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContextsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterancesListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotPrioritiesListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIntentRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, UpdateIntentRequest> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentId").getter(UpdateIntentRequest.getter(UpdateIntentRequest::intentId)).setter(UpdateIntentRequest.setter(Builder::intentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("intentId").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(UpdateIntentRequest.getter(UpdateIntentRequest::intentName)).setter(UpdateIntentRequest.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateIntentRequest.getter(UpdateIntentRequest::description)).setter(UpdateIntentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIntentSignature").getter(UpdateIntentRequest.getter(UpdateIntentRequest::parentIntentSignature)).setter(UpdateIntentRequest.setter(Builder::parentIntentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build()}).build();
    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(UpdateIntentRequest.getter(UpdateIntentRequest::sampleUtterances)).setter(UpdateIntentRequest.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleUtterance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogCodeHook").getter(UpdateIntentRequest.getter(UpdateIntentRequest::dialogCodeHook)).setter(UpdateIntentRequest.setter(Builder::dialogCodeHook)).constructor(DialogCodeHookSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()}).build();
    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook").getter(UpdateIntentRequest.getter(UpdateIntentRequest::fulfillmentCodeHook)).setter(UpdateIntentRequest.setter(Builder::fulfillmentCodeHook)).constructor(FulfillmentCodeHookSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build()}).build();
    private static final SdkField<List<SlotPriority>> SLOT_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotPriorities").getter(UpdateIntentRequest.getter(UpdateIntentRequest::slotPriorities)).setter(UpdateIntentRequest.setter(Builder::slotPriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotPriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotPriority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentConfirmationSetting").getter(UpdateIntentRequest.getter(UpdateIntentRequest::intentConfirmationSetting)).setter(UpdateIntentRequest.setter(Builder::intentConfirmationSetting)).constructor(IntentConfirmationSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build()}).build();
    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intentClosingSetting").getter(UpdateIntentRequest.getter(UpdateIntentRequest::intentClosingSetting)).setter(UpdateIntentRequest.setter(Builder::intentClosingSetting)).constructor(IntentClosingSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build()}).build();
    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputContexts").getter(UpdateIntentRequest.getter(UpdateIntentRequest::inputContexts)).setter(UpdateIntentRequest.setter(Builder::inputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputContexts").getter(UpdateIntentRequest.getter(UpdateIntentRequest::outputContexts)).setter(UpdateIntentRequest.setter(Builder::outputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kendraConfiguration").getter(UpdateIntentRequest.getter(UpdateIntentRequest::kendraConfiguration)).setter(UpdateIntentRequest.setter(Builder::kendraConfiguration)).constructor(KendraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(UpdateIntentRequest.getter(UpdateIntentRequest::botId)).setter(UpdateIntentRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UpdateIntentRequest.getter(UpdateIntentRequest::botVersion)).setter(UpdateIntentRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(UpdateIntentRequest.getter(UpdateIntentRequest::localeId)).setter(UpdateIntentRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD, INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_CODE_HOOK_FIELD, SLOT_PRIORITIES_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD));
    private final String intentId;
    private final String intentName;
    private final String description;
    private final String parentIntentSignature;
    private final List<SampleUtterance> sampleUtterances;
    private final DialogCodeHookSettings dialogCodeHook;
    private final FulfillmentCodeHookSettings fulfillmentCodeHook;
    private final List<SlotPriority> slotPriorities;
    private final IntentConfirmationSetting intentConfirmationSetting;
    private final IntentClosingSetting intentClosingSetting;
    private final List<InputContext> inputContexts;
    private final List<OutputContext> outputContexts;
    private final KendraConfiguration kendraConfiguration;
    private final String botId;
    private final String botVersion;
    private final String localeId;

    private UpdateIntentRequest(BuilderImpl builder) {
        super(builder);
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.slotPriorities = builder.slotPriorities;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
    }

    public final String intentId() {
        return this.intentId;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String description() {
        return this.description;
    }

    public final String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<SampleUtterance> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final DialogCodeHookSettings dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return this.fulfillmentCodeHook;
    }

    public final boolean hasSlotPriorities() {
        return this.slotPriorities != null && !(this.slotPriorities instanceof SdkAutoConstructList);
    }

    public final List<SlotPriority> slotPriorities() {
        return this.slotPriorities;
    }

    public final IntentConfirmationSetting intentConfirmationSetting() {
        return this.intentConfirmationSetting;
    }

    public final IntentClosingSetting intentClosingSetting() {
        return this.intentClosingSetting;
    }

    public final boolean hasInputContexts() {
        return this.inputContexts != null && !(this.inputContexts instanceof SdkAutoConstructList);
    }

    public final List<InputContext> inputContexts() {
        return this.inputContexts;
    }

    public final boolean hasOutputContexts() {
        return this.outputContexts != null && !(this.outputContexts instanceof SdkAutoConstructList);
    }

    public final List<OutputContext> outputContexts() {
        return this.outputContexts;
    }

    public final KendraConfiguration kendraConfiguration() {
        return this.kendraConfiguration;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.intentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotPriorities() ? this.slotPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputContexts() ? this.inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputContexts() ? this.outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntentRequest)) {
            return false;
        }
        UpdateIntentRequest other = (UpdateIntentRequest)((Object)obj);
        return Objects.equals(this.intentId(), other.intentId()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.dialogCodeHook(), other.dialogCodeHook()) && Objects.equals(this.fulfillmentCodeHook(), other.fulfillmentCodeHook()) && this.hasSlotPriorities() == other.hasSlotPriorities() && Objects.equals(this.slotPriorities(), other.slotPriorities()) && Objects.equals(this.intentConfirmationSetting(), other.intentConfirmationSetting()) && Objects.equals(this.intentClosingSetting(), other.intentClosingSetting()) && this.hasInputContexts() == other.hasInputContexts() && Objects.equals(this.inputContexts(), other.inputContexts()) && this.hasOutputContexts() == other.hasOutputContexts() && Objects.equals(this.outputContexts(), other.outputContexts()) && Objects.equals(this.kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIntentRequest").add("IntentId", (Object)this.intentId()).add("IntentName", (Object)this.intentName()).add("Description", (Object)this.description()).add("ParentIntentSignature", (Object)this.parentIntentSignature()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("DialogCodeHook", (Object)this.dialogCodeHook()).add("FulfillmentCodeHook", (Object)this.fulfillmentCodeHook()).add("SlotPriorities", this.hasSlotPriorities() ? this.slotPriorities() : null).add("IntentConfirmationSetting", (Object)this.intentConfirmationSetting()).add("IntentClosingSetting", (Object)this.intentClosingSetting()).add("InputContexts", this.hasInputContexts() ? this.inputContexts() : null).add("OutputContexts", this.hasOutputContexts() ? this.outputContexts() : null).add("KendraConfiguration", (Object)this.kendraConfiguration()).add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentId": {
                return Optional.ofNullable(clazz.cast(this.intentId()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parentIntentSignature": {
                return Optional.ofNullable(clazz.cast(this.parentIntentSignature()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "dialogCodeHook": {
                return Optional.ofNullable(clazz.cast(this.dialogCodeHook()));
            }
            case "fulfillmentCodeHook": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentCodeHook()));
            }
            case "slotPriorities": {
                return Optional.ofNullable(clazz.cast(this.slotPriorities()));
            }
            case "intentConfirmationSetting": {
                return Optional.ofNullable(clazz.cast(this.intentConfirmationSetting()));
            }
            case "intentClosingSetting": {
                return Optional.ofNullable(clazz.cast(this.intentClosingSetting()));
            }
            case "inputContexts": {
                return Optional.ofNullable(clazz.cast(this.inputContexts()));
            }
            case "outputContexts": {
                return Optional.ofNullable(clazz.cast(this.outputContexts()));
            }
            case "kendraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kendraConfiguration()));
            }
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntentRequest, T> g) {
        return obj -> g.apply((UpdateIntentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String intentId;
        private String intentName;
        private String description;
        private String parentIntentSignature;
        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private DialogCodeHookSettings dialogCodeHook;
        private FulfillmentCodeHookSettings fulfillmentCodeHook;
        private List<SlotPriority> slotPriorities = DefaultSdkAutoConstructList.getInstance();
        private IntentConfirmationSetting intentConfirmationSetting;
        private IntentClosingSetting intentClosingSetting;
        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();
        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();
        private KendraConfiguration kendraConfiguration;
        private String botId;
        private String botVersion;
        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntentRequest model) {
            super(model);
            this.intentId(model.intentId);
            this.intentName(model.intentName);
            this.description(model.description);
            this.parentIntentSignature(model.parentIntentSignature);
            this.sampleUtterances(model.sampleUtterances);
            this.dialogCodeHook(model.dialogCodeHook);
            this.fulfillmentCodeHook(model.fulfillmentCodeHook);
            this.slotPriorities(model.slotPriorities);
            this.intentConfirmationSetting(model.intentConfirmationSetting);
            this.intentClosingSetting(model.intentClosingSetting);
            this.inputContexts(model.inputContexts);
            this.outputContexts(model.outputContexts);
            this.kendraConfiguration(model.kendraConfiguration);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
        }

        public final String getIntentId() {
            return this.intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        @Transient
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        @Transient
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        @Transient
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        @Transient
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... sampleUtterances) {
            this.sampleUtterances(Stream.of(sampleUtterances).map(c -> (SampleUtterance)((SampleUtterance.Builder)SampleUtterance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return this.dialogCodeHook != null ? this.dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        @Transient
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return this.fulfillmentCodeHook != null ? this.fulfillmentCodeHook.toBuilder() : null;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        @Override
        @Transient
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final List<SlotPriority.Builder> getSlotPriorities() {
            List<SlotPriority.Builder> result = SlotPrioritiesListCopier.copyToBuilder(this.slotPriorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotPriorities(Collection<SlotPriority.BuilderImpl> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copyFromBuilder(slotPriorities);
        }

        @Override
        @Transient
        public final Builder slotPriorities(Collection<SlotPriority> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copy(slotPriorities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slotPriorities(SlotPriority ... slotPriorities) {
            this.slotPriorities(Arrays.asList(slotPriorities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder slotPriorities(Consumer<SlotPriority.Builder> ... slotPriorities) {
            this.slotPriorities(Stream.of(slotPriorities).map(c -> (SlotPriority)((SlotPriority.Builder)SlotPriority.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return this.intentConfirmationSetting != null ? this.intentConfirmationSetting.toBuilder() : null;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        @Override
        @Transient
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return this.intentClosingSetting != null ? this.intentClosingSetting.toBuilder() : null;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        @Override
        @Transient
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        @Transient
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputContexts(InputContext ... inputContexts) {
            this.inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder> ... inputContexts) {
            this.inputContexts(Stream.of(inputContexts).map(c -> (InputContext)((InputContext.Builder)InputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        @Transient
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputContexts(OutputContext ... outputContexts) {
            this.outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder> ... outputContexts) {
            this.outputContexts(Stream.of(outputContexts).map(c -> (OutputContext)((OutputContext.Builder)OutputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return this.kendraConfiguration != null ? this.kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntentRequest build() {
            return new UpdateIntentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIntentRequest> {
        public Builder intentId(String var1);

        public Builder intentName(String var1);

        public Builder description(String var1);

        public Builder parentIntentSignature(String var1);

        public Builder sampleUtterances(Collection<SampleUtterance> var1);

        public Builder sampleUtterances(SampleUtterance ... var1);

        public Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... var1);

        public Builder dialogCodeHook(DialogCodeHookSettings var1);

        default public Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return this.dialogCodeHook((DialogCodeHookSettings)((DialogCodeHookSettings.Builder)DialogCodeHookSettings.builder().applyMutation(dialogCodeHook)).build());
        }

        public Builder fulfillmentCodeHook(FulfillmentCodeHookSettings var1);

        default public Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return this.fulfillmentCodeHook((FulfillmentCodeHookSettings)((FulfillmentCodeHookSettings.Builder)FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook)).build());
        }

        public Builder slotPriorities(Collection<SlotPriority> var1);

        public Builder slotPriorities(SlotPriority ... var1);

        public Builder slotPriorities(Consumer<SlotPriority.Builder> ... var1);

        public Builder intentConfirmationSetting(IntentConfirmationSetting var1);

        default public Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return this.intentConfirmationSetting((IntentConfirmationSetting)((IntentConfirmationSetting.Builder)IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting)).build());
        }

        public Builder intentClosingSetting(IntentClosingSetting var1);

        default public Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return this.intentClosingSetting((IntentClosingSetting)((IntentClosingSetting.Builder)IntentClosingSetting.builder().applyMutation(intentClosingSetting)).build());
        }

        public Builder inputContexts(Collection<InputContext> var1);

        public Builder inputContexts(InputContext ... var1);

        public Builder inputContexts(Consumer<InputContext.Builder> ... var1);

        public Builder outputContexts(Collection<OutputContext> var1);

        public Builder outputContexts(OutputContext ... var1);

        public Builder outputContexts(Consumer<OutputContext.Builder> ... var1);

        public Builder kendraConfiguration(KendraConfiguration var1);

        default public Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return this.kendraConfiguration((KendraConfiguration)((KendraConfiguration.Builder)KendraConfiguration.builder().applyMutation(kendraConfiguration)).build());
        }

        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

