/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.VoiceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BotLocaleImportSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BotLocaleImportSpecification> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(BotLocaleImportSpecification.getter(BotLocaleImportSpecification::botId)).setter(BotLocaleImportSpecification.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BotLocaleImportSpecification.getter(BotLocaleImportSpecification::botVersion)).setter(BotLocaleImportSpecification.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(BotLocaleImportSpecification.getter(BotLocaleImportSpecification::localeId)).setter(BotLocaleImportSpecification.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("nluIntentConfidenceThreshold").getter(BotLocaleImportSpecification.getter(BotLocaleImportSpecification::nluIntentConfidenceThreshold)).setter(BotLocaleImportSpecification.setter(Builder::nluIntentConfidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold").build()}).build();
    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("voiceSettings").getter(BotLocaleImportSpecification.getter(BotLocaleImportSpecification::voiceSettings)).setter(BotLocaleImportSpecification.setter(Builder::voiceSettings)).constructor(VoiceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, VOICE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final Double nluIntentConfidenceThreshold;
    private final VoiceSettings voiceSettings;

    private BotLocaleImportSpecification(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final Double nluIntentConfidenceThreshold() {
        return this.nluIntentConfidenceThreshold;
    }

    public final VoiceSettings voiceSettings() {
        return this.voiceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotLocaleImportSpecification)) {
            return false;
        }
        BotLocaleImportSpecification other = (BotLocaleImportSpecification)obj;
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold()) && Objects.equals(this.voiceSettings(), other.voiceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"BotLocaleImportSpecification").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("NluIntentConfidenceThreshold", (Object)this.nluIntentConfidenceThreshold()).add("VoiceSettings", (Object)this.voiceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "nluIntentConfidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.nluIntentConfidenceThreshold()));
            }
            case "voiceSettings": {
                return Optional.ofNullable(clazz.cast(this.voiceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotLocaleImportSpecification, T> g) {
        return obj -> g.apply((BotLocaleImportSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private Double nluIntentConfidenceThreshold;
        private VoiceSettings voiceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(BotLocaleImportSpecification model) {
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            this.voiceSettings(model.voiceSettings);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return this.nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return this.voiceSettings != null ? this.voiceSettings.toBuilder() : null;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public BotLocaleImportSpecification build() {
            return new BotLocaleImportSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BotLocaleImportSpecification> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder nluIntentConfidenceThreshold(Double var1);

        public Builder voiceSettings(VoiceSettings var1);

        default public Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return this.voiceSettings((VoiceSettings)((VoiceSettings.Builder)VoiceSettings.builder().applyMutation(voiceSettings)).build());
        }
    }
}

