/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalyticsMetricStatistic {
    SUM("Sum"),
    AVG("Avg"),
    MAX("Max"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalyticsMetricStatistic> VALUE_MAP;
    private final String value;

    private AnalyticsMetricStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalyticsMetricStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalyticsMetricStatistic> knownValues() {
        EnumSet<AnalyticsMetricStatistic> knownValues = EnumSet.allOf(AnalyticsMetricStatistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalyticsMetricStatistic.class, AnalyticsMetricStatistic::toString);
    }
}

