/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBotReplicaResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DeleteBotReplicaResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DeleteBotReplicaResponse.getter(DeleteBotReplicaResponse::botId)).setter(DeleteBotReplicaResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicaRegion").getter(DeleteBotReplicaResponse.getter(DeleteBotReplicaResponse::replicaRegion)).setter(DeleteBotReplicaResponse.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()}).build();
    private static final SdkField<String> BOT_REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botReplicaStatus").getter(DeleteBotReplicaResponse.getter(DeleteBotReplicaResponse::botReplicaStatusAsString)).setter(DeleteBotReplicaResponse.setter(Builder::botReplicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, REPLICA_REGION_FIELD, BOT_REPLICA_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteBotReplicaResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String replicaRegion;
    private final String botReplicaStatus;

    private DeleteBotReplicaResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.replicaRegion = builder.replicaRegion;
        this.botReplicaStatus = builder.botReplicaStatus;
    }

    public final String botId() {
        return this.botId;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final BotReplicaStatus botReplicaStatus() {
        return BotReplicaStatus.fromValue(this.botReplicaStatus);
    }

    public final String botReplicaStatusAsString() {
        return this.botReplicaStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.botReplicaStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotReplicaResponse)) {
            return false;
        }
        DeleteBotReplicaResponse other = (DeleteBotReplicaResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && Objects.equals(this.botReplicaStatusAsString(), other.botReplicaStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBotReplicaResponse").add("BotId", (Object)this.botId()).add("ReplicaRegion", (Object)this.replicaRegion()).add("BotReplicaStatus", (Object)this.botReplicaStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "replicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "botReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.botReplicaStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("botId", BOT_ID_FIELD);
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("botReplicaStatus", BOT_REPLICA_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotReplicaResponse, T> g) {
        return obj -> g.apply((DeleteBotReplicaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String replicaRegion;
        private String botReplicaStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotReplicaResponse model) {
            super(model);
            this.botId(model.botId);
            this.replicaRegion(model.replicaRegion);
            this.botReplicaStatus(model.botReplicaStatus);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final String getBotReplicaStatus() {
            return this.botReplicaStatus;
        }

        public final void setBotReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
        }

        @Override
        public final Builder botReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
            return this;
        }

        @Override
        public final Builder botReplicaStatus(BotReplicaStatus botReplicaStatus) {
            this.botReplicaStatus(botReplicaStatus == null ? null : botReplicaStatus.toString());
            return this;
        }

        @Override
        public DeleteBotReplicaResponse build() {
            return new DeleteBotReplicaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBotReplicaResponse> {
        public Builder botId(String var1);

        public Builder replicaRegion(String var1);

        public Builder botReplicaStatus(String var1);

        public Builder botReplicaStatus(BotReplicaStatus var1);
    }
}

