/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotReplicaSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotReplicasResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotReplicasResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotReplicasResponse.getter(ListBotReplicasResponse::botId)).setter(ListBotReplicasResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRegion").getter(ListBotReplicasResponse.getter(ListBotReplicasResponse::sourceRegion)).setter(ListBotReplicasResponse.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final SdkField<List<BotReplicaSummary>> BOT_REPLICA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botReplicaSummaries").getter(ListBotReplicasResponse.getter(ListBotReplicasResponse::botReplicaSummaries)).setter(ListBotReplicasResponse.setter(Builder::botReplicaSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotReplicaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, SOURCE_REGION_FIELD, BOT_REPLICA_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBotReplicasResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String sourceRegion;
    private final List<BotReplicaSummary> botReplicaSummaries;

    private ListBotReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.sourceRegion = builder.sourceRegion;
        this.botReplicaSummaries = builder.botReplicaSummaries;
    }

    public final String botId() {
        return this.botId;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final boolean hasBotReplicaSummaries() {
        return this.botReplicaSummaries != null && !(this.botReplicaSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotReplicaSummary> botReplicaSummaries() {
        return this.botReplicaSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotReplicaSummaries() ? this.botReplicaSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotReplicasResponse)) {
            return false;
        }
        ListBotReplicasResponse other = (ListBotReplicasResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && this.hasBotReplicaSummaries() == other.hasBotReplicaSummaries() && Objects.equals(this.botReplicaSummaries(), other.botReplicaSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotReplicasResponse").add("BotId", (Object)this.botId()).add("SourceRegion", (Object)this.sourceRegion()).add("BotReplicaSummaries", this.hasBotReplicaSummaries() ? this.botReplicaSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "botReplicaSummaries": {
                return Optional.ofNullable(clazz.cast(this.botReplicaSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("sourceRegion", SOURCE_REGION_FIELD);
        map.put("botReplicaSummaries", BOT_REPLICA_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotReplicasResponse, T> g) {
        return obj -> g.apply((ListBotReplicasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String sourceRegion;
        private List<BotReplicaSummary> botReplicaSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotReplicasResponse model) {
            super(model);
            this.botId(model.botId);
            this.sourceRegion(model.sourceRegion);
            this.botReplicaSummaries(model.botReplicaSummaries);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final List<BotReplicaSummary.Builder> getBotReplicaSummaries() {
            List<BotReplicaSummary.Builder> result = BotReplicaSummaryListCopier.copyToBuilder(this.botReplicaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotReplicaSummaries(Collection<BotReplicaSummary.BuilderImpl> botReplicaSummaries) {
            this.botReplicaSummaries = BotReplicaSummaryListCopier.copyFromBuilder(botReplicaSummaries);
        }

        @Override
        public final Builder botReplicaSummaries(Collection<BotReplicaSummary> botReplicaSummaries) {
            this.botReplicaSummaries = BotReplicaSummaryListCopier.copy(botReplicaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botReplicaSummaries(BotReplicaSummary ... botReplicaSummaries) {
            this.botReplicaSummaries(Arrays.asList(botReplicaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botReplicaSummaries(Consumer<BotReplicaSummary.Builder> ... botReplicaSummaries) {
            this.botReplicaSummaries(Stream.of(botReplicaSummaries).map(c -> (BotReplicaSummary)((BotReplicaSummary.Builder)BotReplicaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBotReplicasResponse build() {
            return new ListBotReplicasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotReplicasResponse> {
        public Builder botId(String var1);

        public Builder sourceRegion(String var1);

        public Builder botReplicaSummaries(Collection<BotReplicaSummary> var1);

        public Builder botReplicaSummaries(BotReplicaSummary ... var1);

        public Builder botReplicaSummaries(Consumer<BotReplicaSummary.Builder> ... var1);
    }
}

