/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSlotTypesResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListSlotTypesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListSlotTypesResponse.getter(ListSlotTypesResponse::botId)).setter(ListSlotTypesResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListSlotTypesResponse.getter(ListSlotTypesResponse::botVersion)).setter(ListSlotTypesResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListSlotTypesResponse.getter(ListSlotTypesResponse::localeId)).setter(ListSlotTypesResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<List<SlotTypeSummary>> SLOT_TYPE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slotTypeSummaries").getter(ListSlotTypesResponse.getter(ListSlotTypesResponse::slotTypeSummaries)).setter(ListSlotTypesResponse.setter(Builder::slotTypeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSlotTypesResponse.getter(ListSlotTypesResponse::nextToken)).setter(ListSlotTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, SLOT_TYPE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSlotTypesResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final List<SlotTypeSummary> slotTypeSummaries;
    private final String nextToken;

    private ListSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.slotTypeSummaries = builder.slotTypeSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final boolean hasSlotTypeSummaries() {
        return this.slotTypeSummaries != null && !(this.slotTypeSummaries instanceof SdkAutoConstructList);
    }

    public final List<SlotTypeSummary> slotTypeSummaries() {
        return this.slotTypeSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotTypeSummaries() ? this.slotTypeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlotTypesResponse)) {
            return false;
        }
        ListSlotTypesResponse other = (ListSlotTypesResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && this.hasSlotTypeSummaries() == other.hasSlotTypeSummaries() && Objects.equals(this.slotTypeSummaries(), other.slotTypeSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSlotTypesResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("SlotTypeSummaries", this.hasSlotTypeSummaries() ? this.slotTypeSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "slotTypeSummaries": {
                return Optional.ofNullable(clazz.cast(this.slotTypeSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("slotTypeSummaries", SLOT_TYPE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSlotTypesResponse, T> g) {
        return obj -> g.apply((ListSlotTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private List<SlotTypeSummary> slotTypeSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlotTypesResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.slotTypeSummaries(model.slotTypeSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<SlotTypeSummary.Builder> getSlotTypeSummaries() {
            List<SlotTypeSummary.Builder> result = SlotTypeSummaryListCopier.copyToBuilder(this.slotTypeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypeSummaries(Collection<SlotTypeSummary.BuilderImpl> slotTypeSummaries) {
            this.slotTypeSummaries = SlotTypeSummaryListCopier.copyFromBuilder(slotTypeSummaries);
        }

        @Override
        public final Builder slotTypeSummaries(Collection<SlotTypeSummary> slotTypeSummaries) {
            this.slotTypeSummaries = SlotTypeSummaryListCopier.copy(slotTypeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeSummaries(SlotTypeSummary ... slotTypeSummaries) {
            this.slotTypeSummaries(Arrays.asList(slotTypeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeSummaries(Consumer<SlotTypeSummary.Builder> ... slotTypeSummaries) {
            this.slotTypeSummaries(Stream.of(slotTypeSummaries).map(c -> (SlotTypeSummary)((SlotTypeSummary.Builder)SlotTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSlotTypesResponse build() {
            return new ListSlotTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSlotTypesResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder slotTypeSummaries(Collection<SlotTypeSummary> var1);

        public Builder slotTypeSummaries(SlotTypeSummary ... var1);

        public Builder slotTypeSummaries(Consumer<SlotTypeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

