/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionAnalyticsDataResponse;

public class ListSessionAnalyticsDataPublisher
implements SdkPublisher<ListSessionAnalyticsDataResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListSessionAnalyticsDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionAnalyticsDataPublisher(LexModelsV2AsyncClient client, ListSessionAnalyticsDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionAnalyticsDataPublisher(LexModelsV2AsyncClient client, ListSessionAnalyticsDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionAnalyticsDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionAnalyticsDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSessionAnalyticsDataResponseFetcher
    implements AsyncPageFetcher<ListSessionAnalyticsDataResponse> {
        private ListSessionAnalyticsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionAnalyticsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionAnalyticsDataResponse> nextPage(ListSessionAnalyticsDataResponse previousPage) {
            if (previousPage == null) {
                return ListSessionAnalyticsDataPublisher.this.client.listSessionAnalyticsData(ListSessionAnalyticsDataPublisher.this.firstRequest);
            }
            return ListSessionAnalyticsDataPublisher.this.client.listSessionAnalyticsData((ListSessionAnalyticsDataRequest)((Object)ListSessionAnalyticsDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

