/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKey;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByKeysCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetricResult;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyticsSessionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyticsSessionResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binKeys").getter(AnalyticsSessionResult.getter(AnalyticsSessionResult::binKeys)).setter(AnalyticsSessionResult.setter(Builder::binKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsSessionGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupByKeys").getter(AnalyticsSessionResult.getter(AnalyticsSessionResult::groupByKeys)).setter(AnalyticsSessionResult.setter(Builder::groupByKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsSessionGroupByKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsSessionMetricResult>> METRICS_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricsResults").getter(AnalyticsSessionResult.getter(AnalyticsSessionResult::metricsResults)).setter(AnalyticsSessionResult.setter(Builder::metricsResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsSessionMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD, GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyticsSessionResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AnalyticsBinKey> binKeys;
    private final List<AnalyticsSessionGroupByKey> groupByKeys;
    private final List<AnalyticsSessionMetricResult> metricsResults;

    private AnalyticsSessionResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
    }

    public final boolean hasBinKeys() {
        return this.binKeys != null && !(this.binKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinKey> binKeys() {
        return this.binKeys;
    }

    public final boolean hasGroupByKeys() {
        return this.groupByKeys != null && !(this.groupByKeys instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsSessionGroupByKey> groupByKeys() {
        return this.groupByKeys;
    }

    public final boolean hasMetricsResults() {
        return this.metricsResults != null && !(this.metricsResults instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsSessionMetricResult> metricsResults() {
        return this.metricsResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinKeys() ? this.binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByKeys() ? this.groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsResults() ? this.metricsResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsSessionResult)) {
            return false;
        }
        AnalyticsSessionResult other = (AnalyticsSessionResult)obj;
        return this.hasBinKeys() == other.hasBinKeys() && Objects.equals(this.binKeys(), other.binKeys()) && this.hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(this.groupByKeys(), other.groupByKeys()) && this.hasMetricsResults() == other.hasMetricsResults() && Objects.equals(this.metricsResults(), other.metricsResults());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyticsSessionResult").add("BinKeys", this.hasBinKeys() ? this.binKeys() : null).add("GroupByKeys", this.hasGroupByKeys() ? this.groupByKeys() : null).add("MetricsResults", this.hasMetricsResults() ? this.metricsResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "binKeys": {
                return Optional.ofNullable(clazz.cast(this.binKeys()));
            }
            case "groupByKeys": {
                return Optional.ofNullable(clazz.cast(this.groupByKeys()));
            }
            case "metricsResults": {
                return Optional.ofNullable(clazz.cast(this.metricsResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("binKeys", BIN_KEYS_FIELD);
        map.put("groupByKeys", GROUP_BY_KEYS_FIELD);
        map.put("metricsResults", METRICS_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsSessionResult, T> g) {
        return obj -> g.apply((AnalyticsSessionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsSessionGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsSessionMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsSessionResult model) {
            this.binKeys(model.binKeys);
            this.groupByKeys(model.groupByKeys);
            this.metricsResults(model.metricsResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey ... binKeys) {
            this.binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... binKeys) {
            this.binKeys(Stream.of(binKeys).map(c -> (AnalyticsBinKey)((AnalyticsBinKey.Builder)AnalyticsBinKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsSessionGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsSessionGroupByKey.Builder> result = AnalyticsSessionGroupByKeysCopier.copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsSessionGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsSessionGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsSessionGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsSessionGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsSessionGroupByKey ... groupByKeys) {
            this.groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsSessionGroupByKey.Builder> ... groupByKeys) {
            this.groupByKeys(Stream.of(groupByKeys).map(c -> (AnalyticsSessionGroupByKey)((AnalyticsSessionGroupByKey.Builder)AnalyticsSessionGroupByKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsSessionMetricResult.Builder> getMetricsResults() {
            List<AnalyticsSessionMetricResult.Builder> result = AnalyticsSessionMetricResultsCopier.copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsSessionMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsSessionMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsSessionMetricResult> metricsResults) {
            this.metricsResults = AnalyticsSessionMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsSessionMetricResult ... metricsResults) {
            this.metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsSessionMetricResult.Builder> ... metricsResults) {
            this.metricsResults(Stream.of(metricsResults).map(c -> (AnalyticsSessionMetricResult)((AnalyticsSessionMetricResult.Builder)AnalyticsSessionMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalyticsSessionResult build() {
            return new AnalyticsSessionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyticsSessionResult> {
        public Builder binKeys(Collection<AnalyticsBinKey> var1);

        public Builder binKeys(AnalyticsBinKey ... var1);

        public Builder binKeys(Consumer<AnalyticsBinKey.Builder> ... var1);

        public Builder groupByKeys(Collection<AnalyticsSessionGroupByKey> var1);

        public Builder groupByKeys(AnalyticsSessionGroupByKey ... var1);

        public Builder groupByKeys(Consumer<AnalyticsSessionGroupByKey.Builder> ... var1);

        public Builder metricsResults(Collection<AnalyticsSessionMetricResult> var1);

        public Builder metricsResults(AnalyticsSessionMetricResult ... var1);

        public Builder metricsResults(Consumer<AnalyticsSessionMetricResult.Builder> ... var1);
    }
}

