/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterancesListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotCaptureSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotConstraint;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotDefaultValueSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotResolutionSetting;
import software.amazon.awssdk.services.lexmodelsv2.model.WaitAndContinueSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotValueElicitationSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotValueElicitationSetting> {
    private static final SdkField<SlotDefaultValueSpecification> DEFAULT_VALUE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultValueSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::defaultValueSpecification)).setter(SlotValueElicitationSetting.setter(Builder::defaultValueSpecification)).constructor(SlotDefaultValueSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueSpecification").build()}).build();
    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotConstraint").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::slotConstraintAsString)).setter(SlotValueElicitationSetting.setter(Builder::slotConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()}).build();
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::promptSpecification)).setter(SlotValueElicitationSetting.setter(Builder::promptSpecification)).constructor(PromptSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build()}).build();
    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sampleUtterances").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::sampleUtterances)).setter(SlotValueElicitationSetting.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleUtterance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WaitAndContinueSpecification> WAIT_AND_CONTINUE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("waitAndContinueSpecification").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::waitAndContinueSpecification)).setter(SlotValueElicitationSetting.setter(Builder::waitAndContinueSpecification)).constructor(WaitAndContinueSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitAndContinueSpecification").build()}).build();
    private static final SdkField<SlotCaptureSetting> SLOT_CAPTURE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slotCaptureSetting").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::slotCaptureSetting)).setter(SlotValueElicitationSetting.setter(Builder::slotCaptureSetting)).constructor(SlotCaptureSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotCaptureSetting").build()}).build();
    private static final SdkField<SlotResolutionSetting> SLOT_RESOLUTION_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slotResolutionSetting").getter(SlotValueElicitationSetting.getter(SlotValueElicitationSetting::slotResolutionSetting)).setter(SlotValueElicitationSetting.setter(Builder::slotResolutionSetting)).constructor(SlotResolutionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionSetting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_SPECIFICATION_FIELD, SLOT_CONSTRAINT_FIELD, PROMPT_SPECIFICATION_FIELD, SAMPLE_UTTERANCES_FIELD, WAIT_AND_CONTINUE_SPECIFICATION_FIELD, SLOT_CAPTURE_SETTING_FIELD, SLOT_RESOLUTION_SETTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SlotValueElicitationSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SlotDefaultValueSpecification defaultValueSpecification;
    private final String slotConstraint;
    private final PromptSpecification promptSpecification;
    private final List<SampleUtterance> sampleUtterances;
    private final WaitAndContinueSpecification waitAndContinueSpecification;
    private final SlotCaptureSetting slotCaptureSetting;
    private final SlotResolutionSetting slotResolutionSetting;

    private SlotValueElicitationSetting(BuilderImpl builder) {
        this.defaultValueSpecification = builder.defaultValueSpecification;
        this.slotConstraint = builder.slotConstraint;
        this.promptSpecification = builder.promptSpecification;
        this.sampleUtterances = builder.sampleUtterances;
        this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
        this.slotCaptureSetting = builder.slotCaptureSetting;
        this.slotResolutionSetting = builder.slotResolutionSetting;
    }

    public final SlotDefaultValueSpecification defaultValueSpecification() {
        return this.defaultValueSpecification;
    }

    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(this.slotConstraint);
    }

    public final String slotConstraintAsString() {
        return this.slotConstraint;
    }

    public final PromptSpecification promptSpecification() {
        return this.promptSpecification;
    }

    public final boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public final List<SampleUtterance> sampleUtterances() {
        return this.sampleUtterances;
    }

    public final WaitAndContinueSpecification waitAndContinueSpecification() {
        return this.waitAndContinueSpecification;
    }

    public final SlotCaptureSetting slotCaptureSetting() {
        return this.slotCaptureSetting;
    }

    public final SlotResolutionSetting slotResolutionSetting() {
        return this.slotResolutionSetting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waitAndContinueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotCaptureSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotResolutionSetting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueElicitationSetting)) {
            return false;
        }
        SlotValueElicitationSetting other = (SlotValueElicitationSetting)obj;
        return Objects.equals(this.defaultValueSpecification(), other.defaultValueSpecification()) && Objects.equals(this.slotConstraintAsString(), other.slotConstraintAsString()) && Objects.equals(this.promptSpecification(), other.promptSpecification()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.waitAndContinueSpecification(), other.waitAndContinueSpecification()) && Objects.equals(this.slotCaptureSetting(), other.slotCaptureSetting()) && Objects.equals(this.slotResolutionSetting(), other.slotResolutionSetting());
    }

    public final String toString() {
        return ToString.builder((String)"SlotValueElicitationSetting").add("DefaultValueSpecification", (Object)this.defaultValueSpecification()).add("SlotConstraint", (Object)this.slotConstraintAsString()).add("PromptSpecification", (Object)this.promptSpecification()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("WaitAndContinueSpecification", (Object)this.waitAndContinueSpecification()).add("SlotCaptureSetting", (Object)this.slotCaptureSetting()).add("SlotResolutionSetting", (Object)this.slotResolutionSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultValueSpecification": {
                return Optional.ofNullable(clazz.cast(this.defaultValueSpecification()));
            }
            case "slotConstraint": {
                return Optional.ofNullable(clazz.cast(this.slotConstraintAsString()));
            }
            case "promptSpecification": {
                return Optional.ofNullable(clazz.cast(this.promptSpecification()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "waitAndContinueSpecification": {
                return Optional.ofNullable(clazz.cast(this.waitAndContinueSpecification()));
            }
            case "slotCaptureSetting": {
                return Optional.ofNullable(clazz.cast(this.slotCaptureSetting()));
            }
            case "slotResolutionSetting": {
                return Optional.ofNullable(clazz.cast(this.slotResolutionSetting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValueSpecification", DEFAULT_VALUE_SPECIFICATION_FIELD);
        map.put("slotConstraint", SLOT_CONSTRAINT_FIELD);
        map.put("promptSpecification", PROMPT_SPECIFICATION_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("waitAndContinueSpecification", WAIT_AND_CONTINUE_SPECIFICATION_FIELD);
        map.put("slotCaptureSetting", SLOT_CAPTURE_SETTING_FIELD);
        map.put("slotResolutionSetting", SLOT_RESOLUTION_SETTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotValueElicitationSetting, T> g) {
        return obj -> g.apply((SlotValueElicitationSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SlotDefaultValueSpecification defaultValueSpecification;
        private String slotConstraint;
        private PromptSpecification promptSpecification;
        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private WaitAndContinueSpecification waitAndContinueSpecification;
        private SlotCaptureSetting slotCaptureSetting;
        private SlotResolutionSetting slotResolutionSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueElicitationSetting model) {
            this.defaultValueSpecification(model.defaultValueSpecification);
            this.slotConstraint(model.slotConstraint);
            this.promptSpecification(model.promptSpecification);
            this.sampleUtterances(model.sampleUtterances);
            this.waitAndContinueSpecification(model.waitAndContinueSpecification);
            this.slotCaptureSetting(model.slotCaptureSetting);
            this.slotResolutionSetting(model.slotResolutionSetting);
        }

        public final SlotDefaultValueSpecification.Builder getDefaultValueSpecification() {
            return this.defaultValueSpecification != null ? this.defaultValueSpecification.toBuilder() : null;
        }

        public final void setDefaultValueSpecification(SlotDefaultValueSpecification.BuilderImpl defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification != null ? defaultValueSpecification.build() : null;
        }

        @Override
        public final Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification;
            return this;
        }

        public final String getSlotConstraint() {
            return this.slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return this.promptSpecification != null ? this.promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... sampleUtterances) {
            this.sampleUtterances(Stream.of(sampleUtterances).map(c -> (SampleUtterance)((SampleUtterance.Builder)SampleUtterance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final WaitAndContinueSpecification.Builder getWaitAndContinueSpecification() {
            return this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.toBuilder() : null;
        }

        public final void setWaitAndContinueSpecification(WaitAndContinueSpecification.BuilderImpl waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification != null ? waitAndContinueSpecification.build() : null;
        }

        @Override
        public final Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification;
            return this;
        }

        public final SlotCaptureSetting.Builder getSlotCaptureSetting() {
            return this.slotCaptureSetting != null ? this.slotCaptureSetting.toBuilder() : null;
        }

        public final void setSlotCaptureSetting(SlotCaptureSetting.BuilderImpl slotCaptureSetting) {
            this.slotCaptureSetting = slotCaptureSetting != null ? slotCaptureSetting.build() : null;
        }

        @Override
        public final Builder slotCaptureSetting(SlotCaptureSetting slotCaptureSetting) {
            this.slotCaptureSetting = slotCaptureSetting;
            return this;
        }

        public final SlotResolutionSetting.Builder getSlotResolutionSetting() {
            return this.slotResolutionSetting != null ? this.slotResolutionSetting.toBuilder() : null;
        }

        public final void setSlotResolutionSetting(SlotResolutionSetting.BuilderImpl slotResolutionSetting) {
            this.slotResolutionSetting = slotResolutionSetting != null ? slotResolutionSetting.build() : null;
        }

        @Override
        public final Builder slotResolutionSetting(SlotResolutionSetting slotResolutionSetting) {
            this.slotResolutionSetting = slotResolutionSetting;
            return this;
        }

        public SlotValueElicitationSetting build() {
            return new SlotValueElicitationSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotValueElicitationSetting> {
        public Builder defaultValueSpecification(SlotDefaultValueSpecification var1);

        default public Builder defaultValueSpecification(Consumer<SlotDefaultValueSpecification.Builder> defaultValueSpecification) {
            return this.defaultValueSpecification((SlotDefaultValueSpecification)((SlotDefaultValueSpecification.Builder)SlotDefaultValueSpecification.builder().applyMutation(defaultValueSpecification)).build());
        }

        public Builder slotConstraint(String var1);

        public Builder slotConstraint(SlotConstraint var1);

        public Builder promptSpecification(PromptSpecification var1);

        default public Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return this.promptSpecification((PromptSpecification)((PromptSpecification.Builder)PromptSpecification.builder().applyMutation(promptSpecification)).build());
        }

        public Builder sampleUtterances(Collection<SampleUtterance> var1);

        public Builder sampleUtterances(SampleUtterance ... var1);

        public Builder sampleUtterances(Consumer<SampleUtterance.Builder> ... var1);

        public Builder waitAndContinueSpecification(WaitAndContinueSpecification var1);

        default public Builder waitAndContinueSpecification(Consumer<WaitAndContinueSpecification.Builder> waitAndContinueSpecification) {
            return this.waitAndContinueSpecification((WaitAndContinueSpecification)((WaitAndContinueSpecification.Builder)WaitAndContinueSpecification.builder().applyMutation(waitAndContinueSpecification)).build());
        }

        public Builder slotCaptureSetting(SlotCaptureSetting var1);

        default public Builder slotCaptureSetting(Consumer<SlotCaptureSetting.Builder> slotCaptureSetting) {
            return this.slotCaptureSetting((SlotCaptureSetting)((SlotCaptureSetting.Builder)SlotCaptureSetting.builder().applyMutation(slotCaptureSetting)).build());
        }

        public Builder slotResolutionSetting(SlotResolutionSetting var1);

        default public Builder slotResolutionSetting(Consumer<SlotResolutionSetting.Builder> slotResolutionSetting) {
            return this.slotResolutionSetting((SlotResolutionSetting)((SlotResolutionSetting.Builder)SlotResolutionSetting.builder().applyMutation(slotResolutionSetting)).build());
        }
    }
}

