/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestSetsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListTestSetsResponse> {
    private static final SdkField<List<TestSetSummary>> TEST_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testSets").getter(ListTestSetsResponse.getter(ListTestSetsResponse::testSets)).setter(ListTestSetsResponse.setter(Builder::testSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestSetsResponse.getter(ListTestSetsResponse::nextToken)).setter(ListTestSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestSetsResponse.memberNameToFieldInitializer();
    private final List<TestSetSummary> testSets;
    private final String nextToken;

    private ListTestSetsResponse(BuilderImpl builder) {
        super(builder);
        this.testSets = builder.testSets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestSets() {
        return this.testSets != null && !(this.testSets instanceof SdkAutoConstructList);
    }

    public final List<TestSetSummary> testSets() {
        return this.testSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestSets() ? this.testSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestSetsResponse)) {
            return false;
        }
        ListTestSetsResponse other = (ListTestSetsResponse)((Object)obj);
        return this.hasTestSets() == other.hasTestSets() && Objects.equals(this.testSets(), other.testSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestSetsResponse").add("TestSets", this.hasTestSets() ? this.testSets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSets": {
                return Optional.ofNullable(clazz.cast(this.testSets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSets", TEST_SETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestSetsResponse, T> g) {
        return obj -> g.apply((ListTestSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<TestSetSummary> testSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestSetsResponse model) {
            super(model);
            this.testSets(model.testSets);
            this.nextToken(model.nextToken);
        }

        public final List<TestSetSummary.Builder> getTestSets() {
            List<TestSetSummary.Builder> result = TestSetSummaryListCopier.copyToBuilder(this.testSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestSets(Collection<TestSetSummary.BuilderImpl> testSets) {
            this.testSets = TestSetSummaryListCopier.copyFromBuilder(testSets);
        }

        @Override
        public final Builder testSets(Collection<TestSetSummary> testSets) {
            this.testSets = TestSetSummaryListCopier.copy(testSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSets(TestSetSummary ... testSets) {
            this.testSets(Arrays.asList(testSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSets(Consumer<TestSetSummary.Builder> ... testSets) {
            this.testSets(Stream.of(testSets).map(c -> (TestSetSummary)((TestSetSummary.Builder)TestSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestSetsResponse build() {
            return new ListTestSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestSetsResponse> {
        public Builder testSets(Collection<TestSetSummary> var1);

        public Builder testSets(TestSetSummary ... var1);

        public Builder testSets(Consumer<TestSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

