/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotRecommendationsResponse;

public class ListBotRecommendationsPublisher
implements SdkPublisher<ListBotRecommendationsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotRecommendationsPublisher(LexModelsV2AsyncClient client, ListBotRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotRecommendationsPublisher(LexModelsV2AsyncClient client, ListBotRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListBotRecommendationsResponse> {
        private ListBotRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotRecommendationsResponse> nextPage(ListBotRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListBotRecommendationsPublisher.this.client.listBotRecommendations(ListBotRecommendationsPublisher.this.firstRequest);
            }
            return ListBotRecommendationsPublisher.this.client.listBotRecommendations((ListBotRecommendationsRequest)((Object)ListBotRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

