/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse;

public class ListSessionMetricsIterable
implements SdkIterable<ListSessionMetricsResponse> {
    private final LexModelsV2Client client;
    private final ListSessionMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSessionMetricsIterable(LexModelsV2Client client, ListSessionMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSessionMetricsResponseFetcher();
    }

    public Iterator<ListSessionMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSessionMetricsResponseFetcher
    implements SyncPageFetcher<ListSessionMetricsResponse> {
        private ListSessionMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSessionMetricsResponse nextPage(ListSessionMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionMetricsIterable.this.client.listSessionMetrics(ListSessionMetricsIterable.this.firstRequest);
            }
            return ListSessionMetricsIterable.this.client.listSessionMetrics((ListSessionMetricsRequest)((Object)ListSessionMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

