/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentDisambiguationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentDisambiguationSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(IntentDisambiguationSettings.getter(IntentDisambiguationSettings::enabled)).setter(IntentDisambiguationSettings.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> MAX_DISAMBIGUATION_INTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDisambiguationIntents").getter(IntentDisambiguationSettings.getter(IntentDisambiguationSettings::maxDisambiguationIntents)).setter(IntentDisambiguationSettings.setter(Builder::maxDisambiguationIntents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDisambiguationIntents").build()}).build();
    private static final SdkField<String> CUSTOM_DISAMBIGUATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDisambiguationMessage").getter(IntentDisambiguationSettings.getter(IntentDisambiguationSettings::customDisambiguationMessage)).setter(IntentDisambiguationSettings.setter(Builder::customDisambiguationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDisambiguationMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MAX_DISAMBIGUATION_INTENTS_FIELD, CUSTOM_DISAMBIGUATION_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntentDisambiguationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer maxDisambiguationIntents;
    private final String customDisambiguationMessage;

    private IntentDisambiguationSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxDisambiguationIntents = builder.maxDisambiguationIntents;
        this.customDisambiguationMessage = builder.customDisambiguationMessage;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer maxDisambiguationIntents() {
        return this.maxDisambiguationIntents;
    }

    public final String customDisambiguationMessage() {
        return this.customDisambiguationMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDisambiguationIntents());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDisambiguationMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentDisambiguationSettings)) {
            return false;
        }
        IntentDisambiguationSettings other = (IntentDisambiguationSettings)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.maxDisambiguationIntents(), other.maxDisambiguationIntents()) && Objects.equals(this.customDisambiguationMessage(), other.customDisambiguationMessage());
    }

    public final String toString() {
        return ToString.builder((String)"IntentDisambiguationSettings").add("Enabled", (Object)this.enabled()).add("MaxDisambiguationIntents", (Object)this.maxDisambiguationIntents()).add("CustomDisambiguationMessage", (Object)this.customDisambiguationMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "maxDisambiguationIntents": {
                return Optional.ofNullable(clazz.cast(this.maxDisambiguationIntents()));
            }
            case "customDisambiguationMessage": {
                return Optional.ofNullable(clazz.cast(this.customDisambiguationMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("maxDisambiguationIntents", MAX_DISAMBIGUATION_INTENTS_FIELD);
        map.put("customDisambiguationMessage", CUSTOM_DISAMBIGUATION_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntentDisambiguationSettings, T> g) {
        return obj -> g.apply((IntentDisambiguationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxDisambiguationIntents;
        private String customDisambiguationMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentDisambiguationSettings model) {
            this.enabled(model.enabled);
            this.maxDisambiguationIntents(model.maxDisambiguationIntents);
            this.customDisambiguationMessage(model.customDisambiguationMessage);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxDisambiguationIntents() {
            return this.maxDisambiguationIntents;
        }

        public final void setMaxDisambiguationIntents(Integer maxDisambiguationIntents) {
            this.maxDisambiguationIntents = maxDisambiguationIntents;
        }

        @Override
        public final Builder maxDisambiguationIntents(Integer maxDisambiguationIntents) {
            this.maxDisambiguationIntents = maxDisambiguationIntents;
            return this;
        }

        public final String getCustomDisambiguationMessage() {
            return this.customDisambiguationMessage;
        }

        public final void setCustomDisambiguationMessage(String customDisambiguationMessage) {
            this.customDisambiguationMessage = customDisambiguationMessage;
        }

        @Override
        public final Builder customDisambiguationMessage(String customDisambiguationMessage) {
            this.customDisambiguationMessage = customDisambiguationMessage;
            return this;
        }

        public IntentDisambiguationSettings build() {
            return new IntentDisambiguationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentDisambiguationSettings> {
        public Builder enabled(Boolean var1);

        public Builder maxDisambiguationIntents(Integer var1);

        public Builder customDisambiguationMessage(String var1);
    }
}

