/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.CustomPayload;
import software.amazon.awssdk.services.lexmodelsv2.model.ImageResponseCard;
import software.amazon.awssdk.services.lexmodelsv2.model.PlainTextMessage;
import software.amazon.awssdk.services.lexmodelsv2.model.SSMLMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<PlainTextMessage> PLAIN_TEXT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("plainTextMessage").getter(Message.getter(Message::plainTextMessage)).setter(Message.setter(Builder::plainTextMessage)).constructor(PlainTextMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainTextMessage").build()}).build();
    private static final SdkField<CustomPayload> CUSTOM_PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customPayload").getter(Message.getter(Message::customPayload)).setter(Message.setter(Builder::customPayload)).constructor(CustomPayload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPayload").build()}).build();
    private static final SdkField<SSMLMessage> SSML_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmlMessage").getter(Message.getter(Message::ssmlMessage)).setter(Message.setter(Builder::ssmlMessage)).constructor(SSMLMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmlMessage").build()}).build();
    private static final SdkField<ImageResponseCard> IMAGE_RESPONSE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageResponseCard").getter(Message.getter(Message::imageResponseCard)).setter(Message.setter(Builder::imageResponseCard)).constructor(ImageResponseCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageResponseCard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_MESSAGE_FIELD, CUSTOM_PAYLOAD_FIELD, SSML_MESSAGE_FIELD, IMAGE_RESPONSE_CARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Message.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PlainTextMessage plainTextMessage;
    private final CustomPayload customPayload;
    private final SSMLMessage ssmlMessage;
    private final ImageResponseCard imageResponseCard;

    private Message(BuilderImpl builder) {
        this.plainTextMessage = builder.plainTextMessage;
        this.customPayload = builder.customPayload;
        this.ssmlMessage = builder.ssmlMessage;
        this.imageResponseCard = builder.imageResponseCard;
    }

    public final PlainTextMessage plainTextMessage() {
        return this.plainTextMessage;
    }

    public final CustomPayload customPayload() {
        return this.customPayload;
    }

    public final SSMLMessage ssmlMessage() {
        return this.ssmlMessage;
    }

    public final ImageResponseCard imageResponseCard() {
        return this.imageResponseCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.plainTextMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmlMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageResponseCard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.plainTextMessage(), other.plainTextMessage()) && Objects.equals(this.customPayload(), other.customPayload()) && Objects.equals(this.ssmlMessage(), other.ssmlMessage()) && Objects.equals(this.imageResponseCard(), other.imageResponseCard());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("PlainTextMessage", (Object)this.plainTextMessage()).add("CustomPayload", (Object)this.customPayload()).add("SsmlMessage", (Object)this.ssmlMessage()).add("ImageResponseCard", (Object)this.imageResponseCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "plainTextMessage": {
                return Optional.ofNullable(clazz.cast(this.plainTextMessage()));
            }
            case "customPayload": {
                return Optional.ofNullable(clazz.cast(this.customPayload()));
            }
            case "ssmlMessage": {
                return Optional.ofNullable(clazz.cast(this.ssmlMessage()));
            }
            case "imageResponseCard": {
                return Optional.ofNullable(clazz.cast(this.imageResponseCard()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("plainTextMessage", PLAIN_TEXT_MESSAGE_FIELD);
        map.put("customPayload", CUSTOM_PAYLOAD_FIELD);
        map.put("ssmlMessage", SSML_MESSAGE_FIELD);
        map.put("imageResponseCard", IMAGE_RESPONSE_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PlainTextMessage plainTextMessage;
        private CustomPayload customPayload;
        private SSMLMessage ssmlMessage;
        private ImageResponseCard imageResponseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.plainTextMessage(model.plainTextMessage);
            this.customPayload(model.customPayload);
            this.ssmlMessage(model.ssmlMessage);
            this.imageResponseCard(model.imageResponseCard);
        }

        public final PlainTextMessage.Builder getPlainTextMessage() {
            return this.plainTextMessage != null ? this.plainTextMessage.toBuilder() : null;
        }

        public final void setPlainTextMessage(PlainTextMessage.BuilderImpl plainTextMessage) {
            this.plainTextMessage = plainTextMessage != null ? plainTextMessage.build() : null;
        }

        @Override
        public final Builder plainTextMessage(PlainTextMessage plainTextMessage) {
            this.plainTextMessage = plainTextMessage;
            return this;
        }

        public final CustomPayload.Builder getCustomPayload() {
            return this.customPayload != null ? this.customPayload.toBuilder() : null;
        }

        public final void setCustomPayload(CustomPayload.BuilderImpl customPayload) {
            this.customPayload = customPayload != null ? customPayload.build() : null;
        }

        @Override
        public final Builder customPayload(CustomPayload customPayload) {
            this.customPayload = customPayload;
            return this;
        }

        public final SSMLMessage.Builder getSsmlMessage() {
            return this.ssmlMessage != null ? this.ssmlMessage.toBuilder() : null;
        }

        public final void setSsmlMessage(SSMLMessage.BuilderImpl ssmlMessage) {
            this.ssmlMessage = ssmlMessage != null ? ssmlMessage.build() : null;
        }

        @Override
        public final Builder ssmlMessage(SSMLMessage ssmlMessage) {
            this.ssmlMessage = ssmlMessage;
            return this;
        }

        public final ImageResponseCard.Builder getImageResponseCard() {
            return this.imageResponseCard != null ? this.imageResponseCard.toBuilder() : null;
        }

        public final void setImageResponseCard(ImageResponseCard.BuilderImpl imageResponseCard) {
            this.imageResponseCard = imageResponseCard != null ? imageResponseCard.build() : null;
        }

        @Override
        public final Builder imageResponseCard(ImageResponseCard imageResponseCard) {
            this.imageResponseCard = imageResponseCard;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder plainTextMessage(PlainTextMessage var1);

        default public Builder plainTextMessage(Consumer<PlainTextMessage.Builder> plainTextMessage) {
            return this.plainTextMessage((PlainTextMessage)((PlainTextMessage.Builder)PlainTextMessage.builder().applyMutation(plainTextMessage)).build());
        }

        public Builder customPayload(CustomPayload var1);

        default public Builder customPayload(Consumer<CustomPayload.Builder> customPayload) {
            return this.customPayload((CustomPayload)((CustomPayload.Builder)CustomPayload.builder().applyMutation(customPayload)).build());
        }

        public Builder ssmlMessage(SSMLMessage var1);

        default public Builder ssmlMessage(Consumer<SSMLMessage.Builder> ssmlMessage) {
            return this.ssmlMessage((SSMLMessage)((SSMLMessage.Builder)SSMLMessage.builder().applyMutation(ssmlMessage)).build());
        }

        public Builder imageResponseCard(ImageResponseCard var1);

        default public Builder imageResponseCard(Consumer<ImageResponseCard.Builder> imageResponseCard) {
            return this.imageResponseCard((ImageResponseCard)((ImageResponseCard.Builder)ImageResponseCard.builder().applyMutation(imageResponseCard)).build());
        }
    }
}

