/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportResourceType {
    BOT("Bot"),
    BOT_LOCALE("BotLocale"),
    CUSTOM_VOCABULARY("CustomVocabulary"),
    TEST_SET("TestSet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportResourceType> VALUE_MAP;
    private final String value;

    private ImportResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportResourceType> knownValues() {
        EnumSet<ImportResourceType> knownValues = EnumSet.allOf(ImportResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportResourceType.class, ImportResourceType::toString);
    }
}

